/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.smime;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapability;

public class SMIMECapabilities
extends ASN1Encodable {
    public static final DERObjectIdentifier canNotDecryptAny;
    private ASN1Sequence capabilities;
    public static final DERObjectIdentifier dES_CBC;
    public static final DERObjectIdentifier dES_EDE3_CBC;
    public static final DERObjectIdentifier preferSignedData;
    public static final DERObjectIdentifier rC2_CBC;
    public static final DERObjectIdentifier sMIMECapabilitesVersions;

    static {
        preferSignedData = PKCSObjectIdentifiers.preferSignedData;
        canNotDecryptAny = PKCSObjectIdentifiers.canNotDecryptAny;
        sMIMECapabilitesVersions = PKCSObjectIdentifiers.sMIMECapabilitiesVersions;
        dES_CBC = new DERObjectIdentifier("1.3.14.3.2.7");
        dES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC;
        rC2_CBC = PKCSObjectIdentifiers.RC2_CBC;
    }

    public SMIMECapabilities(ASN1Sequence seq) {
        this.capabilities = seq;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getCapabilities(DERObjectIdentifier capability) {
        block2: {
            e = this.capabilities.getObjects();
            list = new Vector<SMIMECapability>();
            if (capability != null) ** GOTO lbl15
            while (e.hasMoreElements()) {
                cap = SMIMECapability.getInstance(e.nextElement());
                list.addElement(cap);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                cap = SMIMECapability.getInstance(e.nextElement());
                if (!capability.equals(cap.getCapabilityID())) continue;
                list.addElement(cap);
lbl15:
                // 3 sources

                ** while (e.hasMoreElements())
            }
lbl16:
            // 1 sources

        }
        return list;
    }

    public static SMIMECapabilities getInstance(Object o) {
        if (o == null || o instanceof SMIMECapabilities) {
            return (SMIMECapabilities)o;
        }
        if (o instanceof ASN1Sequence) {
            return new SMIMECapabilities((ASN1Sequence)o);
        }
        if (o instanceof Attribute) {
            return new SMIMECapabilities((ASN1Sequence)((Attribute)o).getAttrValues().getObjectAt(0));
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERObject toASN1Object() {
        return this.capabilities;
    }
}

