/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.smime;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class SMIMECapability
extends ASN1Encodable {
    public static final DERObjectIdentifier canNotDecryptAny;
    private DERObjectIdentifier capabilityID;
    public static final DERObjectIdentifier dES_CBC;
    public static final DERObjectIdentifier dES_EDE3_CBC;
    private DEREncodable parameters;
    public static final DERObjectIdentifier preferSignedData;
    public static final DERObjectIdentifier rC2_CBC;
    public static final DERObjectIdentifier sMIMECapabilitiesVersions;

    static {
        preferSignedData = PKCSObjectIdentifiers.preferSignedData;
        canNotDecryptAny = PKCSObjectIdentifiers.canNotDecryptAny;
        sMIMECapabilitiesVersions = PKCSObjectIdentifiers.sMIMECapabilitiesVersions;
        dES_CBC = new DERObjectIdentifier("1.3.14.3.2.7");
        dES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC;
        rC2_CBC = PKCSObjectIdentifiers.RC2_CBC;
    }

    public SMIMECapability(DERObjectIdentifier capabilityID, DEREncodable parameters) {
        this.capabilityID = capabilityID;
        this.parameters = parameters;
    }

    public SMIMECapability(ASN1Sequence seq) {
        this.capabilityID = (DERObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() > 1) {
            this.parameters = (DERObject)seq.getObjectAt(1);
        }
    }

    public DERObjectIdentifier getCapabilityID() {
        return this.capabilityID;
    }

    public static SMIMECapability getInstance(Object obj) {
        if (obj == null || obj instanceof SMIMECapability) {
            return (SMIMECapability)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SMIMECapability((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid SMIMECapability");
    }

    public DEREncodable getParameters() {
        return this.parameters;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.capabilityID);
        if (this.parameters != null) {
            v.add(this.parameters);
        }
        return new DERSequence(v);
    }
}

