/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class AccessDescription
extends ASN1Encodable {
    GeneralName accessLocation = null;
    DERObjectIdentifier accessMethod = null;

    public AccessDescription(DERObjectIdentifier oid, GeneralName location) {
        this.accessMethod = oid;
        this.accessLocation = location;
    }

    public AccessDescription(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("wrong number of elements in inner sequence");
        }
        this.accessMethod = (DERObjectIdentifier)seq.getObjectAt(0);
        this.accessLocation = GeneralName.getInstance(seq.getObjectAt(1));
    }

    public GeneralName getAccessLocation() {
        return this.accessLocation;
    }

    public DERObjectIdentifier getAccessMethod() {
        return this.accessMethod;
    }

    public static AccessDescription getInstance(Object obj) {
        if (obj instanceof AccessDescription) {
            return (AccessDescription)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new AccessDescription((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector accessDescription = new ASN1EncodableVector();
        accessDescription.add(this.accessMethod);
        accessDescription.add(this.accessLocation);
        return new DERSequence(accessDescription);
    }

    public String toString() {
        return "AccessDescription: Oid(" + this.accessMethod.getId() + ")";
    }
}

