/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.CipherParameters;

public abstract class PBEParametersGenerator {
    protected int iterationCount;
    protected byte[] password;
    protected byte[] salt;

    protected PBEParametersGenerator() {
    }

    public static byte[] PKCS12PasswordToBytes(char[] password) {
        if (password.length > 0) {
            byte[] bytes = new byte[(password.length + 1) * 2];
            int i = 0;
            while (i != password.length) {
                bytes[i * 2] = (byte)(password[i] >>> 8);
                bytes[i * 2 + 1] = (byte)password[i];
                ++i;
            }
            return bytes;
        }
        return new byte[0];
    }

    public static byte[] PKCS5PasswordToBytes(char[] password) {
        byte[] bytes = new byte[password.length];
        int i = 0;
        while (i != bytes.length) {
            bytes[i] = (byte)password[i];
            ++i;
        }
        return bytes;
    }

    public abstract CipherParameters generateDerivedMacParameters(int var1);

    public abstract CipherParameters generateDerivedParameters(int var1, int var2);

    public abstract CipherParameters generateDerivedParameters(int var1);

    public int getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void init(byte[] password, byte[] salt, int iterationCount) {
        this.password = password;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }
}

