/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public AsymmetricCipherKeyPair generateKeyPair() {
        int qLength = this.param.getStrength() - 1;
        ElGamalParameters elParams = this.param.getParameters();
        BigInteger p = elParams.getP();
        BigInteger g = elParams.getG();
        BigInteger x = new BigInteger(qLength, this.param.getRandom());
        BigInteger y = g.modPow(x, p);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, elParams), new ElGamalPrivateKeyParameters(x, elParams));
    }

    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }
}

