/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.SkipjackEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CTSTest
implements Test {
    static byte[] in1 = Hex.decode("4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode("9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode("358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode("170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    CTSTest() {
    }

    public String getName() {
        return "CTS";
    }

    public static void main(String[] args) {
        CTSTest test = new CTSTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        byte[] key1 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] key2 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -18, -1};
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        CTSTester test = new CTSTester(1, new DESEngine(), new KeyParameter(key1), in1, out1);
        TestResult result = test.perform();
        if (!result.isSuccessful()) {
            return result;
        }
        test = new CTSTester(2, new CBCBlockCipher(new DESEngine()), new ParametersWithIV(new KeyParameter(key1), iv), in1, out2);
        result = test.perform();
        if (!result.isSuccessful()) {
            return result;
        }
        test = new CTSTester(3, new CBCBlockCipher(new SkipjackEngine()), new ParametersWithIV(new KeyParameter(key2), iv), in2, out3);
        result = test.perform();
        if (!result.isSuccessful()) {
            return result;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    private class CTSTester
    implements Test {
        private BlockCipher cipher;
        private int id;
        private byte[] input;
        private byte[] output;
        private CipherParameters params;

        CTSTester(int id, BlockCipher cipher, CipherParameters params, byte[] input, byte[] output) {
            this.id = id;
            this.cipher = cipher;
            this.params = params;
            this.input = input;
            this.output = output;
        }

        public String getName() {
            return "CTSTest " + this.id;
        }

        public TestResult perform() {
            byte[] out = new byte[this.input.length];
            CTSBlockCipher engine = new CTSBlockCipher(this.cipher);
            engine.init(true, this.params);
            int len = ((BufferedBlockCipher)engine).processBytes(this.input, 0, this.input.length, out, 0);
            try {
                ((BufferedBlockCipher)engine).doFinal(out, len);
            }
            catch (Exception e) {
                return new SimpleTestResult(false, this.getName() + ": encryption exception - " + e.toString());
            }
            int i = 0;
            while (i != this.output.length) {
                if (out[i] != this.output[i]) {
                    return new SimpleTestResult(false, this.getName() + ": failed encryption expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(out)));
                }
                ++i;
            }
            engine.init(false, this.params);
            len = ((BufferedBlockCipher)engine).processBytes(this.output, 0, this.output.length, out, 0);
            try {
                ((BufferedBlockCipher)engine).doFinal(out, len);
            }
            catch (Exception e) {
                return new SimpleTestResult(false, this.getName() + ": decryption exception - " + e.toString());
            }
            int i2 = 0;
            while (i2 != this.input.length) {
                if (out[i2] != this.input[i2]) {
                    return new SimpleTestResult(false, this.getName() + ": failed encryption expected " + new String(Hex.encode(this.input)) + " got " + new String(Hex.encode(out)));
                }
                ++i2;
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }
}

