/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.util.encoders.Encoder;

public abstract class AbstractCoderTest
extends TestCase {
    private static final int[] SIZES_TO_CHECK = new int[]{64, 128, 1024, 1025, 1026, 2048, 2049, 2050, 4096, 4097, 4098, 8192, 8193, 8194};
    protected Encoder enc;
    private Random r;

    AbstractCoderTest(String name) {
        super(name);
    }

    private void addSpace(ByteArrayOutputStream out) {
        do {
            switch (this.r.nextInt(3)) {
                case 0: {
                    out.write(10);
                    break;
                }
                case 1: {
                    out.write(13);
                    break;
                }
                case 2: {
                    out.write(9);
                    break;
                }
                case 3: {
                    out.write(32);
                }
            }
        } while (this.r.nextBoolean());
    }

    private byte[] addWhitespace(byte[] encoded) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.addSpace(out);
        int i = 0;
        while (i < encoded.length - 5) {
            out.write(encoded, i, 1);
            if (this.r.nextInt(100) < 5) {
                this.addSpace(out);
            }
            ++i;
        }
        int i2 = encoded.length - 5;
        while (i2 < encoded.length) {
            out.write(encoded, i2, 1);
            ++i2;
        }
        this.addSpace(out);
        return out.toByteArray();
    }

    private void checkArrayOfSize(int size) throws IOException {
        byte[] original = new byte[size];
        this.r.nextBytes(original);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.encode(original, 0, original.length, bOut);
        byte[] encoded = bOut.toByteArray();
        Assert.assertTrue(encoded.length > original.length);
        Assert.assertTrue(encoded.length <= original.length * 2);
        this.checkEncoding(encoded);
        this.checkSimpleDecode(original, encoded);
        this.checkStringDecode(original, encoded);
        this.checkOutputStreamDecode(original, encoded);
        int offset = this.r.nextInt(20);
        byte[] offsetEncoded = new byte[offset + encoded.length];
        System.arraycopy(encoded, 0, offsetEncoded, offset, encoded.length);
        this.checkOffsetDecode(original, offsetEncoded, offset, encoded.length);
        offset = this.r.nextInt(20);
        byte[] offsetOriginal = new byte[offset + original.length];
        System.arraycopy(original, 0, offsetOriginal, offset, original.length);
        this.checkOffsetEncode(original, offsetOriginal, offset, original.length);
        byte[] encodedWithSpace = this.addWhitespace(encoded);
        this.checkSimpleDecode(original, encodedWithSpace);
        this.checkStringDecode(original, encodedWithSpace);
        this.checkOutputStreamDecode(original, encodedWithSpace);
    }

    private void checkEncoding(byte[] encoded) {
        String encString = this.convertBytesToString(encoded);
        int i = 0;
        while (i < encString.length()) {
            char c = encString.charAt(i);
            if (c == this.paddingChar()) {
                Assert.assertTrue(i > encString.length() - 3);
            } else if (!this.isEncodedChar(c)) {
                Assert.fail("Unexpected encoded character " + c);
            }
            ++i;
        }
    }

    private void checkOffsetDecode(byte[] original, byte[] encoded, int off, int length) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.decode(encoded, off, length, bOut);
        Assert.assertTrue(Arrays.equals(original, bOut.toByteArray()));
    }

    private void checkOffsetEncode(byte[] original, byte[] offsetOriginal, int off, int length) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.encode(offsetOriginal, off, length, bOut);
        byte[] encoded = bOut.toByteArray();
        bOut.reset();
        this.enc.decode(encoded, 0, encoded.length, bOut);
        Assert.assertTrue(Arrays.equals(original, bOut.toByteArray()));
    }

    private void checkOutputStreamDecode(byte[] original, byte[] encoded) {
        String encString = this.convertBytesToString(encoded);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Assert.assertEquals(original.length, this.enc.decode(encString, out));
            Assert.assertTrue(Arrays.equals(original, out.toByteArray()));
        }
        catch (IOException e) {
            Assert.fail("This shouldn't happen");
        }
    }

    private void checkSimpleDecode(byte[] original, byte[] encoded) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.decode(encoded, 0, encoded.length, bOut);
        Assert.assertTrue(Arrays.equals(original, bOut.toByteArray()));
    }

    private void checkStringDecode(byte[] original, byte[] encoded) throws IOException {
        String encString = this.convertBytesToString(encoded);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.enc.decode(encString, bOut);
        Assert.assertTrue(Arrays.equals(original, bOut.toByteArray()));
    }

    private String convertBytesToString(byte[] encoded) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i != encoded.length) {
            b.append((char)(encoded[i] & 0xFF));
            ++i;
        }
        return b.toString();
    }

    protected abstract boolean isEncodedChar(char var1);

    protected abstract char paddingChar();

    protected void setUp() {
        this.r = new Random();
    }

    public void testEncode() throws IOException {
        int i = 0;
        while (i < SIZES_TO_CHECK.length) {
            this.checkArrayOfSize(SIZES_TO_CHECK[i]);
            ++i;
        }
    }
}

