/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyBorders;
import com.Trendy.swing.plaf.TrendyComboboxEditor;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class TrendyComboBoxUI
extends BasicComboBoxUI {
    ComboBoxMouseListener comboBoxListener = new ComboBoxMouseListener();
    private boolean _$9081 = false;

    public static ComponentUI createUI(JComponent c) {
        return new TrendyComboBoxUI();
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        if (this.arrowButton != null) {
            this.comboBox.add(this.arrowButton);
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void installListeners() {
        super.installListeners();
        this.comboBox.addMouseListener(this.comboBoxListener);
    }

    protected void uninstallListeners() {
        this.comboBox.removeMouseListener(this.comboBoxListener);
        super.uninstallListeners();
    }

    public void installDefaults() {
        super.installDefaults();
    }

    public void paint(Graphics g, JComponent c) {
        if (TrendyUtils.isTooSmall(c) || c.getParent() instanceof JTable) {
            TrendyUtils.drawComboBoxSmallSkin(g, c, this._$9081);
        } else {
            TrendyUtils.drawComboBoxSkin(g, c, this._$9081);
        }
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        c.setBackground(new Color(255, 255, 255, 0));
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    protected JButton createArrowButton() {
        return null;
    }

    protected ComboBoxEditor createEditor() {
        return new TrendyComboboxEditor();
    }

    protected ComboPopup createPopup() {
        return new TrendyComboPopup(this.comboBox);
    }

    private JComboBox _$9093() {
        return this.comboBox;
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        return new Rectangle(5, 2, width - 25, height - 5);
    }

    public class TrendyComboPopup
    extends BasicComboPopup {
        public TrendyComboPopup(JComboBox cBox) {
            super(cBox);
        }

        public Border getBorder1() {
            return TrendyBorders.getComboPopupBorder();
        }

        protected void configureScroller() {
            this.scroller.setFocusable(false);
            this.scroller.getVerticalScrollBar().setFocusable(false);
            this.scroller.setBorder(null);
            this.scroller.setOpaque(false);
        }

        protected void configurePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorderPainted(true);
            this.setBorder(BorderFactory.createLineBorder(new ColorUIResource(120, 120, 120)));
            this.setOpaque(false);
            this.add(this.scroller);
            this.setDoubleBuffered(true);
            this.setFocusable(false);
        }

        protected void configureList() {
            super.configureList();
            this.list.setBackground(Color.white);
        }

        public void delegateFocus(MouseEvent e) {
            super.delegateFocus(e);
        }

        public void show() {
            this._$9104(this.comboBox.getSelectedIndex());
            Point location = this._$9106();
            this.show(this.comboBox, location.x, location.y - 2);
        }

        private void _$9104(int selectedIndex) {
            if (selectedIndex == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(selectedIndex);
                this.list.ensureIndexIsVisible(selectedIndex);
            }
        }

        private Point _$9106() {
            Dimension popupSize = this.comboBox.getSize();
            Insets insets = this.getInsets();
            popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
            Dimension scrollSize = popupBounds.getSize();
            Point popupLocation = popupBounds.getLocation();
            this.scroller.setMaximumSize(scrollSize);
            this.scroller.setPreferredSize(scrollSize);
            this.scroller.setMinimumSize(scrollSize);
            this.list.revalidate();
            return popupLocation;
        }

        public void hide() {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selection = manager.getSelectedPath();
            for (int i = 0; i < selection.length; ++i) {
                if (selection[i] != this) continue;
                manager.clearSelectedPath();
                break;
            }
            TrendyComboBoxUI.this._$9081 = false;
            this.comboBox.repaint();
        }
    }

    class ComboBoxMouseListener
    extends MouseAdapter {
        ComboBoxMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            TrendyComboBoxUI.this._$9081 = true;
            super.mousePressed(e);
            TrendyComboBoxUI.this._$9093().repaint();
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            TrendyComboBoxUI.this._$9093().repaint();
        }

        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            TrendyComboBoxUI.this._$9093().repaint();
        }

        public void mouseExited(MouseEvent e) {
            TrendyComboBoxUI.this._$9081 = false;
            super.mouseExited(e);
            TrendyComboBoxUI.this._$9093().repaint();
        }

        public void mouseReleased(MouseEvent e) {
            TrendyComboBoxUI.this._$9081 = false;
            super.mouseReleased(e);
            TrendyComboBoxUI.this._$9093().repaint();
        }
    }

    class ComboBoxFocusListener
    implements FocusListener {
        ComboBoxFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            TrendyComboBoxUI.this._$9081 = false;
            TrendyComboBoxUI.this._$9093().repaint();
        }

        public void focusLost(FocusEvent e) {
            TrendyComboBoxUI.this._$9081 = false;
            TrendyComboBoxUI.this._$9093().repaint();
        }
    }
}

