/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnLineHolder;
import napkin.NapkinConstants;
import napkin.NapkinUtil;

public class NapkinInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements NapkinConstants {
    private DrawnLineHolder line;
    private Rectangle bounds;
    private static Dimension NO_SIZE = new Dimension(0, 0);

    public NapkinInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    protected LayoutManager createLayout() {
        return new NapkinTitlePaneLayout();
    }

    private Dimension sizeFor(boolean is, boolean pref, JButton button) {
        if (!is) {
            return NO_SIZE;
        }
        return pref ? button.getPreferredSize() : button.getMinimumSize();
    }

    protected void createButtons() {
        super.createButtons();
        this.setupButton(this.iconButton);
        this.setupButton(this.maxButton);
        this.setupButton(this.closeButton);
    }

    private void setupButton(JButton button) {
        if (button != this.maxButton) {
            button.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        button.setOpaque(false);
    }

    public void paint(Graphics g) {
        g = NapkinUtil.defaultGraphics(g, this);
        this.selectedTextColor = this.notSelectedTextColor = g.getColor();
        NapkinUtil.background(g, this);
        super.paint(g);
        NapkinUtil.finishGraphics(g, this);
    }

    protected void paintTitleBackground(Graphics g) {
        if (this.line == null) {
            this.line = new DrawnLineHolder(new DrawnCubicLineGenerator());
        }
        Graphics2D ulG = NapkinUtil.copy(g);
        this.bounds = this.getBounds(this.bounds);
        this.bounds.y = 0;
        this.bounds.x = 0;
        this.line.shapeUpToDate(this.bounds, null);
        ulG.translate(0, this.bounds.height - 2);
        this.line.draw(ulG);
    }

    public class NapkinTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        public NapkinTitlePaneLayout() {
            super(NapkinInternalFrameTitlePane.this);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.calcSize(c, true, 15);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.calcSize(c, false, 3);
        }

        private Dimension calcSize(Container c, boolean pref, int min) {
            Dimension closeSize = NapkinInternalFrameTitlePane.this.sizeFor(NapkinInternalFrameTitlePane.this.frame.isClosable(), pref, NapkinInternalFrameTitlePane.this.closeButton);
            Dimension maxSize = NapkinInternalFrameTitlePane.this.sizeFor(NapkinInternalFrameTitlePane.this.frame.isMaximizable(), pref, NapkinInternalFrameTitlePane.this.maxButton);
            Dimension iconSize = NapkinInternalFrameTitlePane.this.sizeFor(NapkinInternalFrameTitlePane.this.frame.isIconifiable(), pref, NapkinInternalFrameTitlePane.this.iconButton);
            int width = 0;
            width += closeSize.width;
            width += maxSize.width;
            width += iconSize.width;
            FontMetrics fm = NapkinInternalFrameTitlePane.this.getFontMetrics(NapkinInternalFrameTitlePane.this.getFont());
            String frameTitle = NapkinInternalFrameTitlePane.this.frame.getTitle();
            if (frameTitle != null) {
                String replStr;
                int subtitle_w;
                int title_w = fm.stringWidth(frameTitle);
                int title_length = frameTitle.length();
                width = title_length <= min ? (width += title_w) : (width += title_w < (subtitle_w = fm.stringWidth(replStr = frameTitle.substring(0, min) + "...")) ? title_w : subtitle_w);
            }
            Icon icon = NapkinInternalFrameTitlePane.this.frame.getFrameIcon();
            int fontHeight = fm.getHeight();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            int height = Math.max(fontHeight, iconHeight);
            Dimension dim = new Dimension(width, height += 2);
            if (NapkinInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = NapkinInternalFrameTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }
    }
}

