/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import napkin.DrawnBoxHolder;
import napkin.DrawnScribbleHolder;
import napkin.NapkinTheme;
import napkin.NapkinUtil;

public class NapkinProgressBarUI
extends BasicProgressBarUI {
    private final DrawnScribbleHolder scribble = new DrawnScribbleHolder();
    private final Rectangle sz = new Rectangle(0, 0, 0, 0);
    private Rectangle boxRect;
    private DrawnBoxHolder box;
    private Image curImage;
    private Color selectionForeground;
    private Color selectionBackground;

    public static ComponentUI createUI(JComponent c) {
        return NapkinUtil.uiFor(c, new NapkinProgressBarUI());
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    protected void paintIndeterminate(Graphics g1, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g = (Graphics2D)g1;
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect == null) {
            return;
        }
        if (this.box == null) {
            this.box = new DrawnBoxHolder();
            this.box.width = 2.0f;
        }
        this.box.shapeUpToDate(this.boxRect);
        Graphics2D lineG = NapkinUtil.copy(g);
        lineG.setColor(NapkinUtil.currentTheme(c).getCheckColor());
        lineG.translate(this.boxRect.x, this.boxRect.y);
        this.box.draw(lineG);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.width, b);
            } else {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.height, b);
            }
        }
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        boolean backwards;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        c.getBounds(this.sz);
        int orientation = this.progressBar.getOrientation();
        boolean bl = backwards = !NapkinUtil.isLeftToRight(c);
        if (this.scribble.shapeUpToDate(c, this.sz, orientation, amountFull, backwards)) {
            this.curImage = c.createImage(this.sz.x + this.sz.width, this.sz.y + this.sz.height);
            Graphics2D imgG = (Graphics2D)this.curImage.getGraphics();
            Composite origComposit = imgG.getComposite();
            imgG.setComposite(AlphaComposite.Clear);
            imgG.fillRect(0, 0, this.sz.width, this.sz.height);
            imgG.setComposite(origComposit);
            imgG.setColor(NapkinUtil.currentTheme(c).getCheckColor());
            this.scribble.draw(imgG);
        }
        g.drawImage(this.curImage, 0, 0, c);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    public void update(Graphics g, JComponent c) {
        Color checkColor;
        NapkinTheme theme = NapkinUtil.background(g = NapkinUtil.defaultGraphics(g, c), c);
        Color radioColor = theme.getRadioColor();
        if (NapkinUtil.replace(this.selectionForeground, radioColor)) {
            this.selectionForeground = radioColor;
        }
        if (NapkinUtil.replace(this.selectionBackground, checkColor = theme.getCheckColor())) {
            this.selectionBackground = theme.getCheckColor();
        }
        super.update(g, c);
        NapkinUtil.finishGraphics(g, c);
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }
}

