/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnLineHolder;
import napkin.DrawnShapeGenerator;
import napkin.NapkinUtil;

public class NapkinSeparatorUI
extends BasicSeparatorUI {
    private final Separator separator = new Separator();

    public static ComponentUI createUI(JComponent c) {
        return NapkinUtil.uiFor(c, new NapkinSeparatorUI());
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
        this.separator.paint(g, c);
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.separator.getPreferredSize(c);
    }

    public void update(Graphics g, JComponent c) {
        g = NapkinUtil.defaultGraphics(g, c);
        NapkinUtil.background(g, c);
        super.update(g, c);
        NapkinUtil.finishGraphics(g, c);
    }

    public static class Separator {
        private DrawnLineHolder line;

        public void paint(Graphics g, JComponent c) {
            JSeparator sep = (JSeparator)c;
            boolean isVertical = sep.getOrientation() == 1;
            this.doPaint(g, sep, isVertical);
        }

        private void doPaint(Graphics g, JSeparator sep, boolean vertical) {
            if (this.line == null) {
                this.line = new DrawnLineHolder((DrawnShapeGenerator)DrawnCubicLineGenerator.INSTANCE, vertical);
            }
            Rectangle bounds = sep.getBounds();
            bounds.y = 0;
            bounds.x = 0;
            if (vertical) {
                bounds.x = sep.getWidth() / 2;
            } else {
                bounds.y = sep.getHeight() / 2;
            }
            this.line.shapeUpToDate(bounds, null);
            g.setColor(sep.getForeground());
            this.line.draw(g);
        }

        public Dimension getPreferredSize(JComponent c) {
            if (((JSeparator)c).getOrientation() == 1) {
                return new Dimension(5, 0);
            }
            return new Dimension(0, 5);
        }
    }
}

