/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import napkin.DrawnLineHolder;
import napkin.NapkinConstants;
import napkin.NapkinIconFactory;
import napkin.NapkinUtil;

public class NapkinSliderUI
extends BasicSliderUI
implements NapkinConstants {
    private Icon thumb;
    private DrawnLineHolder track;
    private final Rectangle trackBounds;
    private final boolean vertical;
    private final List major;
    private int majorPos;
    private final List minor;
    private int minorPos;
    private final Rectangle tickBounds;

    public static ComponentUI createUI(JComponent c) {
        return NapkinUtil.uiFor(c, new NapkinSliderUI((JSlider)c));
    }

    private NapkinSliderUI(JSlider c) {
        super(c);
        this.vertical = c.getOrientation() == 1;
        this.trackBounds = new Rectangle();
        this.tickBounds = new Rectangle();
        this.major = new ArrayList(0);
        this.minor = new ArrayList(0);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
        this.minorPos = 0;
        this.majorPos = 0;
        super.paint(g, c);
    }

    protected Dimension getThumbSize() {
        if (this.thumb == null) {
            int dir = 5;
            if (this.vertical) {
                dir = NapkinUtil.isLeftToRight(this.slider) ? 3 : 7;
            }
            this.thumb = NapkinIconFactory.createArrowIcon(dir);
        }
        return new Dimension(this.thumb.getIconWidth(), this.thumb.getIconHeight());
    }

    public void setThumbLocation(int x, int y) {
        Rectangle unionRect = new Rectangle(this.thumbRect);
        this.thumbRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, unionRect);
        this.slider.repaint(unionRect.x - 3, unionRect.y - 3, unionRect.width + 6, unionRect.height + 6);
    }

    public void paintThumb(Graphics g) {
        this.thumb.paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
    }

    public void paintTrack(Graphics g) {
        this.trackBounds.width = this.trackRect.width;
        this.trackBounds.height = this.trackRect.height;
        this.trackBounds.x = this.trackRect.x;
        this.trackBounds.y = this.trackRect.y;
        g.setColor(this.slider.getForeground());
        this.track = NapkinUtil.paintLine(g, this.vertical, this.track, this.trackBounds);
    }

    public void paintFocus(Graphics g) {
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.paintTick(this.minor, this.minorPos++, g, x, 0, x, tickBounds.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.paintTick(this.major, this.majorPos++, g, x, 0, x, tickBounds.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.paintTick(this.minor, this.minorPos++, g, 0, y, tickBounds.width / 2 - 1, y);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.paintTick(this.major, this.majorPos++, g, 0, y, tickBounds.width - 2, y);
    }

    private void paintTick(List ticks, int pos, Graphics g, int x, int y, int width, int height) {
        boolean vertTicks = !this.vertical;
        this.tickBounds.x = x;
        this.tickBounds.y = y;
        this.tickBounds.width = width;
        this.tickBounds.height = height;
        if (vertTicks) {
            this.tickBounds.x /= 4;
        } else {
            this.tickBounds.y /= 4;
        }
        while (pos >= ticks.size()) {
            ticks.add(null);
        }
        DrawnLineHolder holder = (DrawnLineHolder)ticks.get(pos);
        g.setColor(this.slider.getForeground());
        holder = NapkinUtil.paintLine(g, vertTicks, holder, this.tickBounds);
        ticks.set(pos, holder);
    }

    public void update(Graphics g, JComponent c) {
        g = NapkinUtil.defaultGraphics(g, c);
        NapkinUtil.background(g, c);
        super.update(g, c);
        NapkinUtil.finishGraphics(g, c);
    }
}

