/*
 * Decompiled with CFR 0.152.
 */
package napkin.examples;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import napkin.NapkinLookAndFeel;
import napkin.NapkinTheme;

public class NapkinQuickTest
implements SwingConstants {
    public static void main(String[] args) throws Exception {
        NapkinLookAndFeel laf;
        if (args.length == 1) {
            if (!args[0].equals("none")) {
                UIManager.setLookAndFeel(args[0]);
            }
            laf = null;
        } else {
            laf = new NapkinLookAndFeel();
            UIManager.setLookAndFeel(laf);
        }
        final NapkinLookAndFeel napkinLAF = laf;
        final HashSet<JComponent> toDisable = new HashSet<JComponent>();
        final JFrame top = new JFrame();
        top.setBackground(Color.cyan);
        JTabbedPane tabbed = new JTabbedPane();
        JPanel mainPanel = new JPanel();
        tabbed.addTab("Main Stuff", mainPanel);
        top.getContentPane().add(tabbed);
        JLabel label = new JLabel("-- Label --");
        if (napkinLAF != null) {
            napkinLAF.setIsFormal(top, true, true);
        }
        mainPanel.setLayout(new GridLayout(4, 2));
        if (napkinLAF != null) {
            napkinLAF.setIsFormal(label, true, false);
        }
        mainPanel.add(label);
        JButton button = new JButton("Button!");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println();
                if (napkinLAF != null) {
                    napkinLAF.dumpFormality(top, System.out);
                }
            }
        });
        if (napkinLAF != null) {
            napkinLAF.setIsFormal(button, true, false);
        }
        mainPanel.add(button);
        boolean formal = napkinLAF != null && napkinLAF.isFormal(label);
        label.setText(formal ? "formal" : "napkin");
        toDisable.add(button);
        JCheckBox checkBox = new JCheckBox("Check?");
        mainPanel.add(checkBox);
        final JCheckBox disableButton = new JCheckBox("Disable");
        disableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean enable = !disableButton.isSelected();
                Iterator it = toDisable.iterator();
                while (it.hasNext()) {
                    JComponent component = (JComponent)it.next();
                    component.setEnabled(enable);
                }
            }
        });
        mainPanel.add(disableButton);
        toDisable.add(checkBox);
        ButtonGroup bgrp = new ButtonGroup();
        JRadioButton r1 = new JRadioButton("Radio?");
        JRadioButton r2 = new JRadioButton("Radio!");
        bgrp.add(r1);
        bgrp.add(r2);
        mainPanel.add(r1);
        mainPanel.add(r2);
        toDisable.add(r1);
        toDisable.add(r2);
        String[] themeNames = NapkinTheme.Manager.themeNames();
        final JComboBox<String> comboBox = new JComboBox<String>(themeNames);
        String currentTheme = NapkinTheme.Manager.getCurrentTheme().getName();
        comboBox.setSelectedItem(currentTheme);
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    String name = (String)comboBox.getSelectedItem();
                    NapkinTheme.Manager.setCurrentTheme(name);
                    UIManager.setLookAndFeel(UIManager.getLookAndFeel());
                    SwingUtilities.updateComponentTreeUI(top);
                }
                catch (UnsupportedLookAndFeelException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        mainPanel.add(comboBox);
        toDisable.add(comboBox);
        JSlider slider = new JSlider(0, -100, 100, 0);
        int majorSpacing = 50;
        slider.setMajorTickSpacing(majorSpacing);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        Hashtable<Integer, JComponent> labels = slider.createStandardLabels(majorSpacing);
        slider.setLabelTable(labels);
        slider.setPaintLabels(true);
        mainPanel.add(slider);
        toDisable.add(slider);
        final JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        final JTextArea textArea = new JTextArea();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 400; ++i) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(i);
            if (i <= 0 || i % 20 != 0) continue;
            textArea.append(sb.toString());
            textArea.append("\n");
            sb.delete(0, 1000);
        }
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(200, 100));
        textPanel.add((Component)scrollPane, "Center");
        JButton loadButton = new JButton("Load File");
        textPanel.add((Component)loadButton, "South");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int result = chooser.showOpenDialog(textPanel);
                if (result == 0) {
                    NapkinQuickTest.loadFile(textArea, chooser.getSelectedFile());
                }
            }
        });
        tabbed.addTab("Text", textPanel);
        JPanel fields = new JPanel();
        fields.setLayout(new BorderLayout());
        JTextField field = new JTextField("of dreams", 20);
        fields.add((Component)new JLabel("Field:"), "West");
        fields.add((Component)field, "Center");
        tabbed.addTab("Fields", fields);
        for (int i = 0; i < 4; ++i) {
            tabbed.addTab("Tab " + i, new JLabel("Just a Label #" + i, 0));
        }
        JPanel tabCtrls = new JPanel();
        ButtonGroup ctlGrp = new ButtonGroup();
        tabCtrls.setLayout(new GridLayout(2, 2));
        NapkinQuickTest.addCtrl(tabbed, tabCtrls, ctlGrp, "top", 1, true);
        NapkinQuickTest.addCtrl(tabbed, tabCtrls, ctlGrp, "right", 4, false);
        NapkinQuickTest.addCtrl(tabbed, tabCtrls, ctlGrp, "left", 2, false);
        NapkinQuickTest.addCtrl(tabbed, tabCtrls, ctlGrp, "bottom", 3, false);
        tabbed.addTab("Controls", tabCtrls);
        top.pack();
        top.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFile(JTextArea textArea, File file) {
        BufferedReader in = null;
        in = new BufferedReader(new FileReader(file));
        textArea.read(in, file);
        Object var6_3 = null;
        if (in == null) return;
        try {
            ((Reader)in).close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                PrintWriter out = new PrintWriter(new StringWriter());
                e.printStackTrace(out);
                out.close();
                textArea.setText(out.toString());
                Object var6_4 = null;
                if (in == null) return;
                try {
                    ((Reader)in).close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (in == null) throw throwable;
            try {
                ((Reader)in).close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static void addCtrl(final JTabbedPane tabs, Container ctrls, ButtonGroup grp, String lab, final int side, boolean on) {
        JRadioButton button = new JRadioButton(lab, on);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                tabs.setTabPlacement(side);
            }
        });
        grp.add(button);
        ctrls.add(button);
    }
}

