/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ftpfactory
extends downloadfactory {
    public static boolean nopasv;
    private DataInputStream is;
    private DataOutputStream os;
    private Socket s;

    ftpfactory(String URL2, qfile qf, boolean dirc) throws MalformedURLException {
        super(URL2, qf, dirc);
    }

    protected void processRequest(InetAddress server, int port, boolean nocache) throws IOException, MalformedURLException {
        this.connect(server, port);
        if (!this.login(null, null)) {
            this.rc = (byte)5;
            return;
        }
        System.out.println("[INFO] FTP login ok");
        this.setBinary(true);
        this.contentSize = this.getFilesize(this.url.getFile());
        if (this.contentSize > 0L) {
            this.fileSize = this.contentSize;
        }
        this.lastModified = this.getFileDate(this.url.getFile());
        this.FTPfileTransfer(this.url.getFile());
    }

    private final long getFilesize(String filename) throws IOException {
        long sz = 0L;
        this.sendCommand("SIZE " + filename);
        String line = this.getReply();
        if (line.startsWith("213 ")) {
            sz = Long.valueOf(line.substring(4).trim());
        }
        return sz;
    }

    private final long getFileDate(String filename) throws IOException {
        long mdtm = 0L;
        this.sendCommand("MDTM " + filename);
        String line = this.getReply();
        if (line.startsWith("213 ") && line.length() >= 18) {
            line = line.substring(4).trim();
            GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
            String part = line.substring(0, 4);
            int value = Integer.valueOf(part);
            c.set(1, value);
            part = line.substring(4, 6);
            value = Integer.valueOf(part);
            c.set(2, value - 1);
            part = line.substring(6, 8);
            value = Integer.valueOf(part);
            c.set(5, value);
            part = line.substring(8, 10);
            value = Integer.valueOf(part);
            c.set(11, value);
            part = line.substring(10, 12);
            value = Integer.valueOf(part);
            c.set(12, value);
            part = line.substring(12, 14);
            value = Integer.valueOf(part);
            c.set(13, value);
            mdtm = c.getTimeInMillis();
        }
        return mdtm;
    }

    private final void FTPfileTransfer(String filename) throws IOException {
        int rc;
        String line;
        Socket data = null;
        ServerSocket portdata = null;
        this.datain = null;
        if (nopasv) {
            line = "NOPASV";
        } else {
            this.sendCommand("PASV");
            line = this.getReply();
        }
        if (line.startsWith("227 ")) {
            int l = line.lastIndexOf(40);
            int r = line.lastIndexOf(41);
            if (l >= 4 && r >= 16 && r > l) {
                StringTokenizer st = new StringTokenizer(line.substring(l + 1, r), ", ");
                if (st.countTokens() != 6) {
                    dmachine.log_err("Not 6 tokens in PASV reply.");
                } else {
                    String ha = "";
                    for (int i = 1; i <= 3; ++i) {
                        ha = ha + st.nextToken() + ".";
                    }
                    ha = ha + st.nextToken();
                    try {
                        data = new Socket(InetAddress.getByName(ha), Integer.valueOf(st.nextToken()) * 256 + Integer.valueOf(st.nextToken()));
                    }
                    catch (IOException ignore) {
                        dmachine.log_err("Connect to FTP server data socket failed");
                        data = null;
                    }
                }
            } else {
                dmachine.log_err("Malformed PASV reply: " + line);
            }
        }
        if (data == null) {
            portdata = new ServerSocket(0);
            InetAddress me = this.s.getLocalAddress();
            int p1 = portdata.getLocalPort() / 256;
            int p2 = portdata.getLocalPort() - 256 * p1;
            this.sendCommand("PORT " + me.getHostAddress().replace('.', ',') + "," + p1 + "," + p2);
            p2 = this.getResponse();
            if (p2 > 300 || p2 < 200) {
                this.rc = (byte)2;
                throw new EOFException("PORT COMMAND failed. rc=" + p2);
            }
        }
        this.rc = 1;
        if (this.havebytes > 0L) {
            this.sendCommand("REST " + this.havebytes);
            rc = this.getResponse();
            if (rc < 400) {
                this.rc = (byte)6;
                if (this.contentSize > 0L) {
                    this.contentSize -= this.havebytes;
                }
            }
        }
        this.sendCommand("RETR " + filename);
        rc = this.getResponse();
        if (rc > 299) {
            this.rc = (byte)3;
            dmachine.log_fatal("FTP RETR Error " + rc + " when loading " + this.qf.getName());
            data.close();
            this.os.close();
            return;
        }
        if (portdata != null) {
            data = portdata.accept();
            portdata.close();
        }
        if (data != null) {
            this.datain = new DataInputStream(data.getInputStream());
        }
    }

    private final void connect(InetAddress hostname, int port) throws IOException {
        this.close();
        this.s = new Socket(hostname, port);
        this.is = new DataInputStream(new BufferedInputStream(this.s.getInputStream(), 4096));
        this.os = new DataOutputStream(new BufferedOutputStream(this.s.getOutputStream(), 4096));
        if (this.getResponse() > 299) {
            this.close();
            this.rc = (byte)2;
            throw new EOFException("No or bad welcome banner");
        }
    }

    private final boolean login(String username, String password) throws IOException {
        if (username == null) {
            username = "anonymous";
        }
        if (password == null) {
            password = "dmachine@";
        }
        this.sendCommand("USER " + username);
        int rc = this.getResponse();
        if (rc >= 400) {
            dmachine.log_err("FTP USER login failed, rc=" + rc);
            return false;
        }
        if (rc == 230) {
            return true;
        }
        if (rc != 331) {
            return false;
        }
        this.sendCommand("PASS " + password);
        rc = this.getResponse();
        if (rc > 299) {
            dmachine.log_err("FTP PASS login failed, rc=" + rc);
            return false;
        }
        return true;
    }

    private final void setBinary(boolean binary) throws IOException {
        if (binary) {
            this.sendCommand("TYPE I");
        } else {
            this.sendCommand("TYPE A");
        }
        int rc = this.getResponse();
        if (rc >= 200 && rc < 300) {
            return;
        }
        this.close();
        throw new EOFException("Can not set binary transfer mode to " + binary + ". rc=" + rc);
    }

    private final void sendCommand(String command) throws IOException {
        this.os.writeBytes(command);
        this.os.writeBytes("\r\n");
        this.os.flush();
    }

    private final String getReply() throws IOException {
        String line = this.is.readLine();
        if (line == null) {
            throw new EOFException();
        }
        return line;
    }

    private final int getResponse() throws IOException {
        int err;
        String line;
        String code = null;
        while (true) {
            if ((line = this.is.readLine()) == null) {
                throw new EOFException();
            }
            if (code != null && !line.startsWith(code)) continue;
            if (line.charAt(3) != '-') break;
            code = line.substring(0, 3) + " ";
        }
        try {
            err = Integer.valueOf(line.substring(0, 3));
        }
        catch (Exception e) {
            throw new EOFException(e.toString());
        }
        return err;
    }

    protected synchronized void close() {
        super.close();
        if (this.s != null) {
            try {
                this.sendCommand("QUIT");
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.s = null;
        this.is = null;
        this.os = null;
    }
}

