/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.zip.CRC32;

public final class qfile
implements Runnable {
    public static regexp[] checkalso;
    public static File[] checkalso_dir;
    public static regexp[] saveto;
    public static File[] saveto_dir;
    private String name;
    private String localname;
    private String[] URL;
    private int[] URLstatus;
    private short retry;
    private int mindown;
    private volatile boolean ok;
    private volatile boolean hold;
    private volatile Thread downloader;

    qfile(String simplename, String url) {
        this.name = simplename;
        this.URL = new String[1];
        this.URL[0] = url;
        this.URLstatus = new int[1];
        this.URLstatus[0] = 0;
        this.ok = false;
        this.hold = false;
        this.downloader = null;
        this.retry = (short)-1;
        this.mindown = 0;
        this.localname = !qfile.isGoodFilename(simplename) ? qfile.genAutoName(simplename) : simplename;
        this.checkOK();
    }

    private final void checkOK() {
        block0: for (int z = 0; z < this.URL.length; ++z) {
            File dir = new File(dmachine.download_dir);
            int i = 0;
            while (true) {
                if (new File(dir, this.localname).exists()) {
                    this.ok = true;
                    System.out.println("[OK] File " + this.name + (this.localname.equals(this.name) ? "" : " (" + this.localname + ")") + " already sucessfully downloaded in directory " + dir);
                    this.removeFromQueues();
                    return;
                }
                if ((i = qfile.isInRegexpArray(this.URL[z], checkalso, i)) <= -1) continue block0;
                dir = checkalso_dir[i++];
            }
        }
    }

    public final boolean addURL(String URL2) {
        if (this.ok) {
            return false;
        }
        for (int i = this.URL.length - 1; i >= 0; --i) {
            if (!this.URL[i].equals(URL2)) continue;
            return false;
        }
        System.out.println("[QUEUE] Alternate URL " + URL2 + " added for file " + this.name);
        this.URL = util.addStringToArray(URL2, this.URL);
        this.URLstatus = util.incIntArraySize(this.URLstatus);
        this.mindown = 0;
        this.hold = false;
        if (this.retry + dmachine.uretry > dmachine.retry) {
            this.retry = (short)(this.retry - dmachine.uretry);
            this.retry = (short)Math.max(0, this.retry);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        this.downloader = Thread.currentThread();
        int siteidx = -1;
        Object object = dmachine.startmon;
        synchronized (object) {
            dmachine.startmon.notify();
        }
        try {
            this.retry = (short)(this.retry + 1);
            if (this.mindown >= dmachine.uretry || this.retry >= dmachine.retry) {
                this.hold = true;
                this.downloader = null;
                return;
            }
            block18: while (siteidx == -1) {
                for (int i = 0; i < this.URLstatus.length; ++i) {
                    if (this.URLstatus[i] > this.mindown) continue;
                    siteidx = i;
                    break block18;
                }
                ++this.mindown;
                if (this.mindown < dmachine.uretry) continue;
                this.hold = true;
                this.downloader = null;
                return;
            }
            System.out.println("[TRYING] URL=" + this.URL[siteidx]);
            int n = siteidx;
            this.URLstatus[n] = this.URLstatus[n] + 1;
            switch (downloadcore.downloadCore(this.URL[siteidx], this)) {
                case 1: {
                    this.ok = true;
                    this.hold = true;
                    this.removeFromQueues();
                    return;
                }
                case 3: {
                    this.URLstatus[siteidx] = dmachine.uretry;
                    return;
                }
                case 5: {
                    int n2 = siteidx;
                    this.URLstatus[n2] = this.URLstatus[n2] - 1;
                    return;
                }
            }
            return;
        }
        catch (UnknownHostException e) {
            dmachine.log_fatal("URL=" + this.URL[siteidx] + " err=" + e.getMessage() + ": Host unknown.");
            this.URLstatus[siteidx] = dmachine.uretry;
            return;
        }
        catch (IOException e) {
            dmachine.log_err(this.name + " I/O err=" + e);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.downloader = null;
        }
    }

    public final boolean equals(Object o) {
        if (o instanceof qfile) {
            qfile q = (qfile)o;
            return this.name.equals(q.name);
        }
        return false;
    }

    public final void redirect(String from, String to) {
        for (int i = 0; i < this.URL.length; ++i) {
            if (!this.URL[i].equals(from)) continue;
            this.URLstatus[i] = dmachine.uretry;
            System.out.println("[REDIRECT] " + from + " => " + to);
            this.addURL(to);
            if (!qfile.isGoodFilename(this.name) && qfile.genLocalName(to) != null) {
                this.localname = qfile.genLocalName(to);
                this.checkOK();
                if (this.ok) {
                    this.touch();
                }
            }
            return;
        }
    }

    private static final boolean isGoodFilename(String n) {
        if (n == null) {
            return false;
        }
        if (n.length() == 0) {
            return false;
        }
        if (n.indexOf("/") > -1) {
            return false;
        }
        if (n.indexOf("\\") > -1) {
            return false;
        }
        return n.indexOf(":") <= -1;
    }

    public static final String genAutoName(String uname) {
        CRC32 crc = new CRC32();
        crc.update(uname.getBytes());
        return dmachine.auto_prefix + Long.toHexString(crc.getValue()) + dmachine.auto_suffix;
    }

    private static final String genLocalName(String uname) {
        try {
            URL u = new URL(uname);
            String result = dmachine.getFilename(u.getFile());
            if (result == null || result.length() == 0) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final String getLocalName() {
        return this.localname;
    }

    public final boolean isActive() {
        return this.downloader != null;
    }

    public final boolean needsDownload() {
        if (this.ok) {
            return false;
        }
        if (this.isActive()) {
            return false;
        }
        return !this.hold;
    }

    public final void touch() {
        File f = new File(dmachine.download_dir, qfile.genAutoName(this.name));
        try {
            FileOutputStream fos = new FileOutputStream(f.toString(), true);
            for (int i = 0; i < this.URL.length; ++i) {
                fos.write(this.URL[i].getBytes());
                fos.write(10);
            }
            fos.write(this.localname.getBytes());
            fos.write(10);
            fos.close();
            System.out.println("[INFO] Touched " + qfile.genAutoName(this.name) + " for " + this.name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void removeFromQueues() {
        for (int i = dmachine.queue_files.length - 1; i >= 0; --i) {
            queuefile q = dmachine.queue_files[i];
            for (int j = this.URL.length - 1; j >= 0; --j) {
                q.removeURL(this.URL[j]);
            }
            q.savefile();
        }
    }

    static final regexp[] addRegexpToArray(String what, regexp[] array) {
        if (what == null) {
            return array;
        }
        if (array == null) {
            array = new regexp[]{new regexp(what, true)};
            return array;
        }
        regexp[] tmp = new regexp[array.length + 1];
        System.arraycopy(array, 0, tmp, 0, array.length);
        tmp[array.length] = new regexp(what, true);
        return tmp;
    }

    static final int isInRegexpArray(String what, regexp[] array, int start) {
        if (array == null) {
            return -1;
        }
        for (int i = start; i < array.length; ++i) {
            if (!array[i].matches(what)) continue;
            return i;
        }
        return -1;
    }

    static final File[] addFileToArray(File what, File[] array) {
        if (what == null) {
            return array;
        }
        if (array == null) {
            array = new File[]{what};
            return array;
        }
        int ar = array.length;
        File[] tmp = new File[ar + 1];
        System.arraycopy(array, 0, tmp, 0, ar);
        tmp[ar] = what;
        return tmp;
    }

    static final void addCheckAlso(String regexp2, String dir) {
        int i = 0;
        while (true) {
            if ((i = qfile.isInRegexpArray(regexp2, checkalso, i)) == -1) {
                checkalso = qfile.addRegexpToArray(regexp2, checkalso);
                checkalso_dir = qfile.addFileToArray(new File(dir), checkalso_dir);
                return;
            }
            if (checkalso_dir[i].equals(new File(dir))) {
                return;
            }
            ++i;
        }
    }

    static final void addSaveto(String regexp2, String dir) {
        int i = 0;
        i = qfile.isInRegexpArray(regexp2, saveto, 0);
        if (i == -1) {
            saveto = qfile.addRegexpToArray(regexp2, saveto);
            saveto_dir = qfile.addFileToArray(new File(dir), saveto_dir);
        } else {
            qfile.saveto_dir[i] = new File(dir);
        }
    }
}

