/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.LanguageBinding;
import cz.vity.freerapid.core.SupportedLanguage;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import jlibs.xml.sax.binding.BindingHandler;
import org.xml.sax.InputSource;

public final class Lng {
    private static final Logger logger = Logger.getLogger(Lng.class.getName());
    private static final String LANG_LIST_FILE = "languages.xml";
    private static final String LOCALE_LANG_CODE = Locale.getDefault().getLanguage();
    private static final String LOCALE_COUNTRY_CODE = Locale.getDefault().getCountry();
    private static List<SupportedLanguage> supportedLanguages = null;
    private static String selLanguageCode;
    private static String selCountryCode;

    private Lng() {
    }

    public static synchronized List<SupportedLanguage> getSupportedLanguages() {
        if (supportedLanguages == null) {
            BindingHandler handler = new BindingHandler(LanguageBinding.class);
            try {
                List list;
                supportedLanguages = list = (List)handler.parse(new InputSource(Utils.class.getClassLoader().getResourceAsStream(LANG_LIST_FILE)));
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
                supportedLanguages = Collections.emptyList();
            }
        }
        return supportedLanguages;
    }

    private static SupportedLanguage findSupportedLanguage(SupportedLanguage lang) {
        for (SupportedLanguage supportedLanguage : Lng.getSupportedLanguages()) {
            if (!supportedLanguage.equals(lang)) continue;
            return supportedLanguage;
        }
        return null;
    }

    public static void loadLangProperties() {
        SupportedLanguage result;
        selLanguageCode = AppPrefs.getProperty("selLanguage", null);
        if (selLanguageCode == null) {
            result = Lng.findSupportedLanguage(new SupportedLanguage(LOCALE_LANG_CODE, LOCALE_COUNTRY_CODE));
            if (result == null && (result = Lng.findSupportedLanguage(new SupportedLanguage(LOCALE_LANG_CODE, ""))) == null) {
                result = new SupportedLanguage("EN", "");
            }
        } else {
            selCountryCode = AppPrefs.getProperty("country", "");
            result = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, selCountryCode));
            if (result == null && (result = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, ""))) == null) {
                result = new SupportedLanguage("EN", "");
            }
        }
        selLanguageCode = result.getLanguageCode();
        selCountryCode = result.getCountry();
        Locale selLocale = new Locale(selLanguageCode.toLowerCase(Locale.ENGLISH), ("".equals(selCountryCode) ? LOCALE_COUNTRY_CODE : selCountryCode).toUpperCase(Locale.ENGLISH));
        logger.info("Setting locale " + selLocale);
        Locale.setDefault(selLocale);
    }

    public static SupportedLanguage getSelectedLanguage() {
        SupportedLanguage result = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, selCountryCode));
        if (result == null && (result = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, ""))) == null) {
            result = new SupportedLanguage("EN", "");
        }
        return result;
    }
}

