/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.Swinger;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class SpeedCellRenderer
extends DefaultTableCellRenderer {
    private ImageIcon iconImage;
    private ResourceMap map;

    SpeedCellRenderer(ApplicationContext context) {
        this.map = context.getResourceMap();
        this.iconImage = Swinger.getIconImage("speedLimitImage");
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = table.getValueAt(row, column);
        }
        DownloadFile downloadFile = (DownloadFile)value;
        this.setIcon(null);
        String tooltip = null;
        if (downloadFile.getState() == DownloadState.DOWNLOADING) {
            if (downloadFile.getSpeed() >= 0L) {
                value = ContentPanel.bytesToAnother(downloadFile.getSpeed()) + "/s";
                if (downloadFile.hasSpeedLimit()) {
                    this.setIcon(this.iconImage);
                    tooltip = this.map.getString("speedLimitIsEnabled", ContentPanel.bytesToAnother((long)downloadFile.getSpeedLimit() * 1024L));
                }
            } else {
                value = "0 B/s";
            }
        } else {
            value = "";
        }
        this.setToolTipText(tooltip);
        this.getAccessibleContext().setAccessibleName(table.getColumnName(column) + " " + value.toString());
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

