/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.abouteffect;

import cz.vity.freerapid.gui.dialogs.abouteffect.SingleExplosion;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashSet;
import java.util.Set;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.ease.Spline;

public class VolleyExplosion {
    private int x;
    private int y;
    private Color color;
    private final Set<SingleExplosion> circles;

    public VolleyExplosion(int x, int y, Color color) {
        this.x = x;
        this.y = y;
        this.color = color;
        this.circles = new HashSet<SingleExplosion>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineScenario getExplosionScenario() {
        TimelineScenario.Parallel scenario = new TimelineScenario.Parallel();
        int duration = 1000 + (int)(1000.0 * Math.random());
        for (int i = 0; i < 18; ++i) {
            float dist = (float)(50.0 + 10.0 * Math.random());
            float radius = (float)(2.0 + 2.0 * Math.random());
            for (float delta = 0.6f; delta <= 1.0f; delta += 0.2f) {
                float circleRadius = radius * delta;
                double degrees = 20.0 * ((double)i + Math.random());
                float radians = (float)(Math.PI * 2 * degrees / 360.0);
                float initDist = delta * dist / 10.0f;
                float finalDist = delta * dist;
                float initX = (float)((double)this.x + (double)initDist * Math.cos(radians));
                float initY = (float)((double)this.y + (double)initDist * Math.sin(radians));
                float finalX = (float)((double)this.x + (double)finalDist * Math.cos(radians));
                float finalY = (float)((double)this.y + (double)finalDist * Math.sin(radians));
                SingleExplosion circle = new SingleExplosion(this.color, initX, initY, circleRadius);
                Timeline timeline = new Timeline(circle);
                timeline.addPropertyToInterpolate("x", Float.valueOf(initX), Float.valueOf(finalX));
                timeline.addPropertyToInterpolate("y", Float.valueOf(initY), Float.valueOf(finalY));
                timeline.addPropertyToInterpolate("opacity", Float.valueOf(1.0f), Float.valueOf(0.0f));
                timeline.setDuration(duration - 200 + (int)(400.0 * Math.random()));
                timeline.setEase(new Spline(0.4f));
                Set<SingleExplosion> set = this.circles;
                synchronized (set) {
                    this.circles.add(circle);
                }
                scenario.addScenarioActor(timeline);
            }
        }
        return scenario;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Set<SingleExplosion> set = this.circles;
        synchronized (set) {
            for (SingleExplosion circle : this.circles) {
                circle.paint(g);
            }
        }
    }
}

