/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.PNMEncodeParam;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Scanner;
import java.util.logging.Logger;

class GOCR {
    private static final Logger logger = Logger.getLogger(GOCR.class.getName());
    private final BufferedImage image;
    private final String commandLineOptions;
    private static final String PATH_WINDOWS = "tools\\gocr\\gocr.exe";
    private static final String PATH_LINUX = "gocr";

    public GOCR(BufferedImage image, String commandLineOptions) {
        this.image = image;
        this.commandLineOptions = commandLineOptions;
    }

    public String recognize() throws IOException {
        String command = Utils.isWindows() ? Utils.addFileSeparator(Utils.getAppPath()) + PATH_WINDOWS : PATH_LINUX;
        Scanner scanner = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PNMEncodeParam param = new PNMEncodeParam();
            param.setRaw(false);
            ImageEncoder encoder = ImageCodec.createImageEncoder("PNM", out, param);
            assert (encoder != null);
            encoder.encode(this.image);
            Process process = Runtime.getRuntime().exec(command + " " + this.commandLineOptions + " -f ASCII -");
            OutputStream processOut = process.getOutputStream();
            processOut.write(out.toByteArray());
            processOut.close();
            scanner = new Scanner(process.getInputStream());
            StringBuilder builder = new StringBuilder();
            while (scanner.hasNext()) {
                builder.append(scanner.next());
            }
            String s = builder.toString();
            if (s == null || s.isEmpty()) {
                throw new IllegalStateException("No output");
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new IOException("Process exited abnormally");
            }
            String string = s;
            return string;
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            throw new IOException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                LogUtils.processException(logger, e);
            }
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception e) {
                    LogUtils.processException(logger, e);
                }
            }
        }
    }
}

