/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities.os;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.win32.StdCallLibrary;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import cz.vity.freerapid.utilities.os.AbstractSystemCommander;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SysCommand;
import cz.vity.freerapid.utilities.os.WindowsShellLink;
import cz.vity.freerapid.utilities.os.WindowsShutdownUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

class WindowsCommander
extends AbstractSystemCommander {
    private static final Logger logger = Logger.getLogger(WindowsCommander.class.getName());
    private static final int ES_CONTINUOUS = Integer.MIN_VALUE;
    private static final int ES_SYSTEM_REQUIRED = 1;

    WindowsCommander() {
        try {
            Shell32 shell32 = (Shell32)Native.loadLibrary("shell32", Shell32.class);
            shell32.SetCurrentProcessExplicitAppUserModelID(new WString("FreeRapid"));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(OSCommand command) {
        return true;
    }

    @Override
    public boolean createShortCut(OSCommand shortCutCommand) {
        if (!OSCommand.shortCutCommands.contains((Object)shortCutCommand)) {
            throw new IllegalArgumentException("OS command " + (Object)((Object)shortCutCommand) + " is not a shortcut command");
        }
        switch (shortCutCommand) {
            case CREATE_DESKTOP_SHORTCUT: {
                return this.createShortCut(Shell32Util.getFolderPath(0));
            }
            case CREATE_QUICKLAUNCH_SHORTCUT: {
                return this.createShortCut(Utils.addFileSeparator(Shell32Util.getFolderPath(26)) + "Microsoft\\Internet Explorer\\Quick Launch");
            }
            case CREATE_STARTMENU_SHORTCUT: {
                return this.createShortCut(Shell32Util.getFolderPath(2));
            }
            case CREATE_STARTUP_SHORTCUT: {
                return this.createShortCut(Shell32Util.getFolderPath(7), "-m");
            }
        }
        assert (false);
        return false;
    }

    private boolean createShortCut(String folder) {
        return this.createShortCut(folder, null);
    }

    private boolean createShortCut(String folder, String arguments) {
        String shortcutFile = Utils.addFileSeparator(folder) + "FreeRapid 0.9u4" + ".lnk";
        String appPath = Utils.addFileSeparator(Utils.getAppPath());
        String exe = appPath + "frd.exe";
        String icon = appPath + "frd.ico";
        WindowsShellLink shellLink = new WindowsShellLink(shortcutFile);
        shellLink.setTarget(exe);
        shellLink.setWorkingDirectory(appPath);
        shellLink.setIconLocation(icon);
        shellLink.setArguments(arguments);
        return shellLink.save();
    }

    @Override
    public boolean shutDown(OSCommand shutDownCommand, boolean force) {
        if (!OSCommand.shutDownCommands.contains((Object)shutDownCommand)) {
            throw new IllegalArgumentException("OS command " + (Object)((Object)shutDownCommand) + " is not a shut down command");
        }
        switch (shutDownCommand) {
            case RESTART_APPLICATION: {
                return this.startNewApplicationInstance();
            }
            case HIBERNATE: {
                return WindowsShutdownUtils.hibernate();
            }
            case STANDBY: {
                return WindowsShutdownUtils.standby();
            }
            case REBOOT: {
                return WindowsShutdownUtils.reboot(force);
            }
            case SHUTDOWN: {
                return WindowsShutdownUtils.shutdown(force);
            }
        }
        assert (false);
        return false;
    }

    private boolean startNewApplicationInstance() {
        String exe;
        if (!System.getProperties().containsKey("exePath")) {
            String appPath = Utils.getAppPath();
            String appSep = Utils.addFileSeparator(appPath);
            exe = appSep + "frd.exe";
        } else {
            exe = System.getProperty("exePath");
        }
        return WindowsCommander.run(exe + " " + Utils.getApplicationArguments(), false);
    }

    private static boolean run(String cmd, boolean waitForResult) {
        if (!Utils.isWindows()) {
            return true;
        }
        logger.info("System command: " + cmd);
        try {
            Process process = Runtime.getRuntime().exec(SysCommand.splitCommand(cmd));
            if (waitForResult) {
                process.waitFor();
                return process.exitValue() == 0;
            }
            return true;
        }
        catch (IOException e) {
            logger.warning("Command: " + cmd + " failed for some reason");
            LogUtils.processException(logger, e);
            return false;
        }
        catch (InterruptedException e) {
            LogUtils.processException(logger, e);
            return false;
        }
    }

    @Override
    public boolean findTopLevelWindow(String windowTitle, final boolean caseSensitive) throws IOException {
        final String stringToFind = caseSensitive ? windowTitle : windowTitle.toLowerCase();
        final boolean[] result = new boolean[]{false};
        User32.INSTANCE.EnumWindows(new WinUser.WNDENUMPROC(){

            @Override
            public boolean callback(WinDef.HWND hwnd, Pointer pointer) {
                String title = WindowsCommander.getWindowTitle(hwnd);
                if (title != null) {
                    if (!caseSensitive) {
                        title = title.toLowerCase();
                    }
                    if (title.contains(stringToFind)) {
                        result[0] = true;
                        return false;
                    }
                }
                return true;
            }
        }, Pointer.NULL);
        return result[0];
    }

    @Override
    public List<String> getTopLevelWindowsList() throws IOException {
        final LinkedList<String> list = new LinkedList<String>();
        User32.INSTANCE.EnumWindows(new WinUser.WNDENUMPROC(){

            @Override
            public boolean callback(WinDef.HWND hwnd, Pointer pointer) {
                String title = WindowsCommander.getWindowTitle(hwnd);
                if (title != null) {
                    list.add(title);
                }
                return true;
            }
        }, Pointer.NULL);
        return list;
    }

    private static String getWindowTitle(WinDef.HWND hwnd) {
        char[] name;
        int len = User32.INSTANCE.GetWindowTextLength(hwnd);
        if (len > 0 && (len = User32.INSTANCE.GetWindowText(hwnd, name = new char[Math.min(len, 2048)], name.length)) > 0) {
            return new String(name, 0, len);
        }
        return null;
    }

    @Override
    public void preventSystemStandby(boolean prevent) {
        int flags = Integer.MIN_VALUE;
        if (prevent) {
            flags |= 1;
        }
        Kernel32.INSTANCE.SetThreadExecutionState(flags);
    }

    static {
        if (System.getProperty("os.arch", "").contains("64")) {
            System.setProperty("jna.boot.library.name", "jnidispatch64");
        } else {
            System.setProperty("jna.boot.library.name", "jnidispatch32");
        }
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary("kernel32", Kernel32.class);

        public void SetThreadExecutionState(int var1);
    }

    private static interface Shell32
    extends StdCallLibrary {
        public NativeLong SetCurrentProcessExplicitAppUserModelID(WString var1);
    }
}

