/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph;

import java.util.regex.Pattern;
import jlibs.core.graph.Convertor;
import jlibs.core.graph.Ladder;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.PredicateConvertor;
import jlibs.core.graph.Sequence;

public abstract class Navigator2<E>
extends Ladder<E>
implements Navigator<E> {
    public String getRelativePath(E fromElem, E toElem, Convertor<E, String> convertor, String separator, boolean predicates) {
        if (predicates) {
            convertor = new PredicateConvertor<E>(this, convertor);
        }
        return super.getRelativePath(fromElem, toElem, convertor, separator);
    }

    public E resolve(E node, String path, Convertor<E, String> convertor, String separator) {
        String[] tokens;
        if (path.equals(".")) {
            return node;
        }
        block0: for (String token : tokens = Pattern.compile(separator, 16).split(path)) {
            if (token.equals("..")) {
                node = this.parent(node);
                continue;
            }
            int predicate = 1;
            int openBrace = token.lastIndexOf(91);
            if (openBrace != -1) {
                predicate = Integer.parseInt(token.substring(openBrace + 1, token.length() - 1));
                token = token.substring(0, openBrace);
            }
            Sequence<E> children = this.children(node);
            while (children.hasNext()) {
                E child = children.next();
                if (!token.equals(convertor.convert(child))) continue;
                if (predicate == 1) {
                    node = child;
                    continue block0;
                }
                --predicate;
            }
        }
        return null;
    }
}

