/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.resource.ResourceHelper;

public class OptionException
extends Exception {
    public static final Set HELP_SETTINGS = Collections.unmodifiableSet(Collections.singleton(DisplaySetting.DISPLAY_PROPERTY_OPTION));
    private static final ResourceHelper helper = ResourceHelper.getResourceHelper();
    private final Option option;
    private final String message;

    public OptionException(Option option) {
        this(option, null, null);
    }

    public OptionException(Option option, String messageKey) {
        this(option, messageKey, null);
    }

    public OptionException(Option option, String messageKey, String value) {
        this.option = option;
        if (messageKey != null) {
            StringBuffer buffer = new StringBuffer();
            if (value != null) {
                buffer.append(helper.getMessage(messageKey, value));
            } else {
                buffer.append(helper.getMessage(messageKey));
            }
            buffer.append(" ");
            option.appendUsage(buffer, HELP_SETTINGS, null);
            this.message = buffer.toString();
        } else {
            this.message = "";
        }
    }

    public Option getOption() {
        return this.option;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

