/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding.impl.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.namespace.QName;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.annotation.processing.Printer;
import jlibs.core.lang.StringUtil;
import jlibs.core.lang.model.ModelUtil;
import jlibs.xml.sax.binding.SAXContext;
import jlibs.xml.sax.binding.impl.processor.Binding;

abstract class BindingAnnotation {
    protected String methodDecl;
    protected Class annotation;

    BindingAnnotation(Class annotation, String methodDecl) {
        this.annotation = annotation;
        this.methodDecl = methodDecl;
    }

    public void consume(Binding binding, ExecutableElement method, AnnotationMirror mirror) {
        this.validate(method, mirror);
    }

    protected boolean matches(AnnotationMirror mirror) {
        return ((TypeElement)mirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(this.annotation.getCanonicalName());
    }

    protected void validate(ExecutableElement method, AnnotationMirror mirror) {
        this.validateModifiers(method);
    }

    public String lvalue(ExecutableElement method) {
        return "";
    }

    public abstract String params(ExecutableElement var1);

    protected void validateModifiers(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        if (!modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.FINAL)) {
            throw new AnnotationError((Element)method, "method with annotation " + this.annotation + " must be final");
        }
    }

    protected boolean matches(ExecutableElement method, int paramIndex, Class expected) {
        return this.matches(method.getParameters().get(paramIndex), expected);
    }

    protected boolean matches(VariableElement param, Class expected) {
        Name paramType;
        return param.asType().getKind() == TypeKind.DECLARED && (paramType = ((TypeElement)((DeclaredType)param.asType()).asElement()).getQualifiedName()).contentEquals(expected.getName());
    }

    protected String context(ExecutableElement method, int paramIndex, boolean parent) {
        return this.context(method.getParameters().get(paramIndex), parent);
    }

    protected String context(VariableElement param, boolean parent) {
        String str = ModelUtil.toString((TypeMirror)param.asType(), (boolean)true);
        if (str.equals(SAXContext.class.getName())) {
            return this.toString(parent);
        }
        return "(" + str + ")" + this.toString(parent) + ".object";
    }

    private String toString(boolean parent) {
        return parent ? "parent" : "current";
    }

    public void printMethod(Printer pw, Binding binding) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        if (this.getMethods(binding, methods)) {
            pw.println("@Override");
            pw.println(this.methodDecl);
            ++pw.indent;
            pw.println("switch(state){");
            ++pw.indent;
            int id = 0;
            for (ExecutableElement method : methods) {
                if (method != null) {
                    pw.print("case " + id + ":");
                    List<QName> path = binding.idMap.get(id);
                    if (path.size() > 0) {
                        pw.println(" // " + StringUtil.join(path.iterator(), (String)"/"));
                    } else {
                        pw.println();
                    }
                    ++pw.indent;
                    this.printCase(pw, method);
                    pw.println("break;");
                    --pw.indent;
                }
                ++id;
            }
            --pw.indent;
            pw.println("}");
            --pw.indent;
            pw.println("}");
            pw.emptyLine(true);
        }
    }

    abstract boolean getMethods(Binding var1, List<ExecutableElement> var2);

    private void printCase(Printer pw, ExecutableElement method) {
        String lvalue = this.lvalue(method);
        pw.print(lvalue);
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            pw.print(pw.clazz.getSimpleName() + "." + method.getSimpleName() + "(" + this.params(method) + ")");
        } else {
            pw.print("handler." + method.getSimpleName() + "(" + this.params(method) + ")");
        }
        if (lvalue.length() > 0 && !lvalue.endsWith("= ")) {
            pw.print(")");
        }
        pw.println(";");
    }
}

