/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding.impl.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.xml.namespace.QName;
import jlibs.core.lang.StringUtil;
import jlibs.core.lang.model.ModelUtil;
import jlibs.xml.sax.binding.Attr;
import jlibs.xml.sax.binding.Binding;
import jlibs.xml.sax.binding.Temp;
import jlibs.xml.sax.binding.impl.processor.Binding;
import jlibs.xml.sax.binding.impl.processor.BindingAnnotation;
import jlibs.xml.sax.binding.impl.processor.BindingRelation;
import org.xml.sax.Attributes;

class BindingStartAnnotation
extends BindingAnnotation {
    BindingStartAnnotation() {
        super(Binding.Start.class, "public void startElement(int state, SAXContext current, Attributes attributes) throws SAXException{");
    }

    @Override
    public void consume(Binding binding, ExecutableElement method, AnnotationMirror mirror) {
        super.consume(binding, method, mirror);
        for (AnnotationValue xpath : (Collection)ModelUtil.getAnnotationValue((Element)method, (AnnotationMirror)mirror, (String)"value")) {
            binding.getBinding((ExecutableElement)method, (AnnotationMirror)mirror, (String)((String)xpath.getValue())).startMethod = method;
        }
    }

    @Override
    public String lvalue(ExecutableElement method) {
        switch (method.getReturnType().getKind()) {
            case VOID: {
                return "";
            }
            case DECLARED: {
                if (!ModelUtil.toString((TypeMirror)method.getReturnType(), (boolean)true).equals(Attributes.class.getName())) break;
                String m = ModelUtil.getAnnotationMirror((Element)method, Temp.Add.class) == null ? "put" : "add";
                return "current." + m + "Attributes(";
            }
        }
        return "current.object = ";
    }

    @Override
    public String params(ExecutableElement method) {
        ArrayList<String> params = new ArrayList<String>();
        for (VariableElement variableElement : method.getParameters()) {
            AnnotationMirror mirror = ModelUtil.getAnnotationMirror((Element)variableElement, Attr.class);
            if (mirror == null) {
                if (this.matches(variableElement, Attributes.class)) {
                    params.add("attributes");
                    continue;
                }
                params.add(this.context(variableElement, false));
                continue;
            }
            String value = (String)ModelUtil.getAnnotationValue((Element)variableElement, (AnnotationMirror)mirror, (String)"value");
            if (value.length() == 0) {
                value = variableElement.getSimpleName().toString();
            }
            StringBuilder buff = new StringBuilder();
            buff.append("attributes.getValue(");
            if (value.contains(":")) {
                QName qname = Binding.toQName(variableElement, mirror, value);
                if (qname.getNamespaceURI().length() > 0) {
                    buff.append('\"').append(qname.getNamespaceURI()).append("\", ");
                }
                buff.append('\"').append(qname.getLocalPart()).append('\"');
            } else {
                buff.append('\"').append(value).append('\"');
            }
            buff.append(")");
            params.add(buff.toString());
        }
        return StringUtil.join(params.iterator());
    }

    @Override
    boolean getMethods(Binding binding, List<ExecutableElement> methods) {
        boolean nonEmpty = binding.startMethod != null;
        methods.add(binding.startMethod);
        for (BindingRelation bindingRelation : binding.registry.values()) {
            nonEmpty |= this.getMethods(bindingRelation.binding, methods);
        }
        return nonEmpty;
    }
}

