/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsIconFactory;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.plaf.RolloverButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicMenuUI;

public class PgsMenuUI
extends BasicMenuUI {
    public static ComponentUI createUI(JComponent c) {
        return new PgsMenuUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addMouseListener(this.createButtonListener(this.menuItem));
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        Dimension size = menuItem.getSize();
        if (menuItem.getParent() instanceof JMenuBar) {
            if (menuItem.isEnabled() && (model.isArmed() || menuItem instanceof JMenu && model.isSelected() || model.isRollover())) {
                if (PgsUtils.isFlat("MenuBarMenu")) {
                    if (model.isSelected()) {
                        g.setColor(UIManager.getColor("MenuBarMenu.selectedBackground"));
                    } else {
                        g.setColor(UIManager.getColor("MenuBarMenu.rolloverBackground"));
                    }
                    g.fillRect(0, 0, size.width, size.height);
                } else if (PlafOptions.isVistaStyle()) {
                    if (model.isRollover() && !model.isSelected()) {
                        PgsUtils.drawVistaBackground(g, menuItem, "MenuBarMenu.rolloverBackground");
                    } else {
                        PgsUtils.drawVistaBackground(g, menuItem, "MenuBarMenu.selectedBackground");
                    }
                } else if (model.isRollover() && !model.isSelected()) {
                    PgsUtils.drawGradient(g, menuItem.getWidth(), menuItem.getHeight(), UIManager.getColor("MenuBarMenu.rolloverBackgroundGradientStart"), UIManager.getColor("MenuBarMenu.rolloverBackgroundGradientEnd"));
                } else {
                    PgsUtils.drawGradient(g, menuItem.getWidth(), menuItem.getHeight(), UIManager.getColor("MenuBarMenu.selectedBackgroundGradientStart"), UIManager.getColor("MenuBarMenu.selectedBackgroundGradientEnd"));
                }
                if (model.isRollover() && !model.isSelected()) {
                    g.setColor(UIManager.getColor("MenuBarMenu.rolloverBorderColor"));
                    g.drawRect(0, 0, size.width - 1, size.height - 1);
                } else {
                    g.setColor(UIManager.getColor("MenuBarMenu.selectedBorderColor"));
                    g.drawLine(0, 0, 0, size.height - 1);
                    g.drawLine(size.width - 1, 0, size.width - 1, size.height - 1);
                    g.drawLine(0, 0, size.width - 1, 0);
                }
            } else if (PgsUtils.isFlat("MenuBar")) {
                g.setColor(UIManager.getColor("MenuBar.background"));
                g.fillRect(0, 0, size.width, size.height);
            } else if (PlafOptions.isVistaStyle()) {
                PgsUtils.drawVistaBackground(g, menuItem, "MenuBar");
            } else {
                PgsUtils.drawGradient(g, menuItem.getWidth(), menuItem.getHeight(), UIManager.getColor("MenuBar.gradientStart"), UIManager.getColor("MenuBar.gradientEnd"));
            }
        } else {
            if (menuItem.getIcon() == null) {
                menuItem.setIcon(PgsIconFactory.getEmptyIcon());
            }
            PgsUtils.paintMenuItemBackground(g, menuItem, bgColor, this.getPropertyPrefix());
        }
        g.setColor(oldColor);
    }

    @Override
    protected void paintText(Graphics g, JMenuItem c, Rectangle textRect, String text) {
        PgsUtils.installAntialiasing(g);
        if (c.getParent() instanceof JMenuBar) {
            c.setForeground(UIManager.getColor("MenuBarMenu.foreground"));
            this.selectionForeground = UIManager.getColor("MenuBarMenu.foreground");
        }
        super.paintText(g, c, textRect, text);
        PgsUtils.uninstallAntialiasing(g);
    }
}

