/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.session;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.proxy.ProxyConnector;
import org.apache.mina.proxy.ProxyLogicHandler;
import org.apache.mina.proxy.event.IoSessionEventQueue;
import org.apache.mina.proxy.filter.ProxyFilter;
import org.apache.mina.proxy.handlers.ProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpAuthenticationMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyIoSession {
    public static final String PROXY_SESSION = ProxyConnector.class.getName() + ".ProxySession";
    private List<HttpAuthenticationMethods> preferedOrder;
    private ProxyRequest request;
    private ProxyLogicHandler handler;
    private ProxyFilter proxyFilter;
    private IoSession session;
    private ProxyConnector connector;
    private InetSocketAddress proxyAddress = null;
    private boolean reconnectionNeeded = false;
    private String charsetName;
    private IoSessionEventQueue eventQueue = new IoSessionEventQueue(this);
    private boolean authenticationFailed;

    public ProxyIoSession(InetSocketAddress inetSocketAddress, ProxyRequest proxyRequest) {
        this.setProxyAddress(inetSocketAddress);
        this.setRequest(proxyRequest);
    }

    public IoSessionEventQueue getEventQueue() {
        return this.eventQueue;
    }

    public List<HttpAuthenticationMethods> getPreferedOrder() {
        return this.preferedOrder;
    }

    public ProxyLogicHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ProxyLogicHandler proxyLogicHandler) {
        this.handler = proxyLogicHandler;
    }

    public ProxyFilter getProxyFilter() {
        return this.proxyFilter;
    }

    public void setProxyFilter(ProxyFilter proxyFilter) {
        this.proxyFilter = proxyFilter;
    }

    public ProxyRequest getRequest() {
        return this.request;
    }

    private void setRequest(ProxyRequest proxyRequest) {
        if (proxyRequest == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        this.request = proxyRequest;
    }

    public IoSession getSession() {
        return this.session;
    }

    public void setSession(IoSession ioSession) {
        this.session = ioSession;
    }

    public ProxyConnector getConnector() {
        return this.connector;
    }

    public void setConnector(ProxyConnector proxyConnector) {
        this.connector = proxyConnector;
    }

    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    private void setProxyAddress(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            throw new IllegalArgumentException("proxyAddress object cannot be null");
        }
        this.proxyAddress = inetSocketAddress;
    }

    public boolean isReconnectionNeeded() {
        return this.reconnectionNeeded;
    }

    public void setReconnectionNeeded(boolean bl) {
        this.reconnectionNeeded = bl;
    }

    public Charset getCharset() {
        return Charset.forName(this.getCharsetName());
    }

    public String getCharsetName() {
        if (this.charsetName == null) {
            this.charsetName = "ISO-8859-1";
        }
        return this.charsetName;
    }

    public boolean isAuthenticationFailed() {
        return this.authenticationFailed;
    }

    public void setAuthenticationFailed(boolean bl) {
        this.authenticationFailed = bl;
    }
}

