/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base.dir;

import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.UITool;
import net.sf.jftp.gui.base.dir.Dir;
import net.sf.jftp.gui.framework.GUIDefaults;
import net.sf.jftp.gui.tasks.PathChanger;
import net.sf.jftp.net.FilesystemConnection;

public class DirCanvas
extends JPanel
implements MouseListener {
    JLabel text = new JLabel(" ");
    private Dir target;
    boolean active = false;

    public DirCanvas(Dir target) {
        this.target = target;
        this.setLayout(new FlowLayout(0));
        this.add(this.text);
        this.addMouseListener(this);
        this.setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.target.getType().equals("local") || this.target.getCon() instanceof FilesystemConnection) {
            String tmp = UITool.getPathFromDialog(Settings.defaultWorkDir);
            if (tmp != null) {
                this.target.setPath(tmp);
                this.target.fresh();
            }
        } else {
            PathChanger p = new PathChanger("remote");
            this.target.fresh();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(12));
        this.active = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(0));
        this.active = false;
        this.repaint();
    }

    public void setText(String msg) {
        this.text.setText(msg);
        this.validate();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.active) {
            g.setColor(GUIDefaults.light);
        } else {
            g.setColor(GUIDefaults.lightActive);
        }
        g.fillRect(3, 0, this.getSize().width - 6, this.getSize().height);
        g.setColor(GUIDefaults.front);
        g.drawRect(3, 0, this.getSize().width - 7, this.getSize().height - 1);
        g.drawRect(3, 0, this.getSize().width - 8, this.getSize().height - 2);
    }

    @Override
    public Insets getInsets() {
        Insets in = super.getInsets();
        return new Insets(in.top, in.left, in.bottom, in.right);
    }
}

