/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.tasks;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.sf.jftp.config.LoadSet;
import net.sf.jftp.config.SaveSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.net.FtpConnection;

public class AdvancedOptions
extends HPanel
implements ActionListener {
    public static boolean listOptionSet = false;
    private HTextField listCommand = new HTextField("FTP LIST command:", FtpConnection.LIST, 15);
    private JButton setListCommand = new JButton("Set");
    private JButton saveCommand = new JButton("Set and Save");
    private JLabel text = new JLabel();
    private JLabel statusText = new JLabel();
    private String listOptionText = new String();

    public AdvancedOptions() {
        this.setLayout(new BorderLayout(5, 5));
        this.text.setText("Default values for commands can be overidden here.");
        this.statusText.setText("Note: The FTP LIST command should be \"LIST\" when connecting to an OS/2 server.");
        this.text.setPreferredSize(new Dimension(400, 30));
        this.statusText.setPreferredSize(new Dimension(400, 30));
        if (listOptionSet) {
            this.listOptionText = FtpConnection.LIST;
        } else if (LoadSet.loadSet(Settings.adv_settings) != null) {
            this.listOptionText = LoadSet.loadSet(Settings.adv_settings)[0];
        } else {
            this.listOptionText = FtpConnection.LIST_DEFAULT;
            SaveSet s = new SaveSet(Settings.adv_settings, FtpConnection.LIST_DEFAULT);
        }
        this.listCommand.setText(this.listOptionText);
        HPanel content = new HPanel();
        HPanel panel = new HPanel();
        panel.add(this.listCommand);
        panel.add(this.setListCommand);
        panel.add(this.saveCommand);
        content.add(panel);
        this.add("North", this.text);
        this.add("Center", content);
        this.add("South", this.statusText);
        this.setListCommand.addActionListener(this);
        this.saveCommand.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.setListCommand) {
            FtpConnection.LIST = this.listCommand.getText().trim();
            this.statusText.setText("LIST command set.");
            listOptionSet = true;
        } else {
            FtpConnection.LIST = this.listCommand.getText().trim();
            listOptionSet = true;
            SaveSet s = new SaveSet(Settings.adv_settings, this.listCommand.getText().trim());
            this.statusText.setText("LIST command set and saved.");
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(super.getInsets().top + 5, super.getInsets().left + 5, super.getInsets().bottom + 5, super.getInsets().right + 5);
    }
}

