/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.tasks;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JLabel;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HButton;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.system.logging.Log;

public class ProxyChooser
extends HPanel
implements ActionListener {
    private HTextField proxy;
    private HTextField port;
    private HButton ok = new HButton("Ok");

    public ProxyChooser() {
        this.setLayout(new FlowLayout(0));
        this.proxy = new HTextField("Socks proxy:", "");
        this.port = new HTextField("Port:", "");
        this.proxy.setText(Settings.getSocksProxyHost());
        this.port.setText(Settings.getSocksProxyPort());
        this.add(this.proxy);
        this.add(this.port);
        this.add(this.ok);
        this.add(new JLabel("Please note that you have to restart JFtp to apply the changes!"));
        this.ok.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            String h = this.proxy.getText().trim();
            String p = this.port.getText().trim();
            Properties sysprops = System.getProperties();
            sysprops.remove("socksProxyHost");
            sysprops.remove("socksProxyPort");
            Settings.setProperty("jftp.socksProxyHost", h);
            Settings.setProperty("jftp.socksProxyPort", p);
            Settings.save();
            Log.out("proxy vars: " + h + ":" + p);
            if (h.equals("") || p.equals("")) {
                return;
            }
            sysprops.put("socksProxyHost", h);
            sysprops.put("socksProxyPort", p);
            Log.out("new proxy vars set.");
            this.remove(3);
            this.add(new JLabel("Options set. Please restart JFtp."));
            this.validate();
            this.setVisible(true);
        }
    }
}

