/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net.wrappers;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.jftp.net.wrappers.Sftp2Connection;
import net.sf.jftp.system.logging.Log;

public class Sftp2URLConnection
extends URLConnection {
    private Sftp2Connection connection = null;
    private String username = "user";
    private String password = "none@no.no";
    private boolean loginFlag = false;

    public Sftp2URLConnection(URL u) {
        super(u);
        int index;
        int port = u.getPort() > 0 ? u.getPort() : 22;
        this.connection = new Sftp2Connection(u.getHost(), "" + port, null);
        String userInfo = u.getUserInfo();
        if (userInfo != null && (index = userInfo.indexOf(":")) != -1) {
            this.username = userInfo.substring(0, index);
            this.password = userInfo.substring(index + 1);
        }
        Log.debug("Connecting...");
    }

    @Override
    public void connect() throws IOException {
        this.loginFlag = this.connection.login(this.username, this.password);
        if (!this.loginFlag) {
            return;
        }
        this.connection.chdir(this.url.getPath());
    }

    public Sftp2Connection getSftp2Connection() {
        return this.connection;
    }

    public String getUser() {
        return this.username;
    }

    public String getPass() {
        return this.password;
    }

    public String getHost() {
        return this.url.getHost();
    }

    public int getPort() {
        int ret = this.url.getPort();
        if (ret <= 0) {
            return 22;
        }
        return ret;
    }

    public boolean loginSucceeded() {
        return this.loginFlag;
    }
}

