/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.tools;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JPanel;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.StatusCanvas;
import net.sf.jftp.gui.framework.HImageButton;
import net.sf.jftp.system.LocalIO;
import net.sf.jftp.system.logging.Log;
import net.sf.jftp.tools.RSSParser;

public class RSSFeeder
extends JPanel
implements Runnable,
ActionListener {
    public static String urlstring = Settings.getRSSFeed();
    Thread runner;
    URL url;
    RSSParser parser;
    StatusCanvas can = new StatusCanvas();
    HImageButton next = new HImageButton(Settings.nextRSSImage, "nextRSS", "Display next RSS news item", this);
    boolean header = false;
    boolean breakHeader = false;
    int HEADER_IVAL = 4000;
    int LOAD_IVAL = 1860000;

    public RSSFeeder() {
        this.setLayout(new BorderLayout(0, 0));
        this.next.setPreferredSize(new Dimension(22, 22));
        this.next.setMaximumSize(new Dimension(22, 22));
        this.add("West", this.next);
        this.add("Center", this.can);
        this.setPreferredSize(new Dimension(500, 25));
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void switchTo(String u) {
        if (u == null) {
            return;
        }
        urlstring = u;
        this.runner.stop();
        this.runner = new Thread(this);
        this.runner.start();
    }

    @Override
    public void run() {
        long time;
        LocalIO.pause(3000);
        Log.out("Starting RSS Feed");
        try {
            this.can.setInterval(10);
            this.url = new URL(urlstring);
            this.parser = new RSSParser(this.url);
            time = System.currentTimeMillis();
        }
        catch (Exception ex) {
            Log.debug("Error: Can't load RSS feed (" + ex + ")");
            ex.printStackTrace();
            return;
        }
        while (true) {
            try {
                Enumeration e = this.parser.titles.elements();
                Enumeration e2 = this.parser.descs.elements();
                while (e.hasMoreElements()) {
                    this.can.setText((String)e.nextElement());
                    this.next.setEnabled(true);
                    this.header = true;
                    for (int i = 0; !this.breakHeader && i < 100; ++i) {
                        LocalIO.pause(this.HEADER_IVAL / 100);
                    }
                    this.next.setEnabled(false);
                    this.breakHeader = false;
                    this.header = false;
                    if (!e2.hasMoreElements()) continue;
                    this.next.setEnabled(true);
                    this.can.scrollText((String)e2.nextElement());
                    this.next.setEnabled(false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (System.currentTimeMillis() <= (long)this.LOAD_IVAL + time) continue;
            this.parser = new RSSParser(this.url);
            time = System.currentTimeMillis();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.next) {
            if (this.header) {
                this.breakHeader = true;
            } else {
                this.can.forward();
            }
        }
    }
}

