/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorCallback;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.security.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Set;
import java.util.Vector;

public class Main
implements ActivityCallback,
ErrorCallback {
    public static void main(String[] args) {
        Main callback = new Main();
        RouterService service = new RouterService(callback);
        service.preGuiInit();
        service.start();
        System.out.println("For a command list type help.");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("LimeRouter> ");
            try {
                String command = in.readLine();
                if (command == null) break;
                if (command.equals("help")) {
                    System.out.println("catcher                  Print host catcher.");
                    System.out.println("connect <host> [<port>]  Connect to a host[:port].");
                    System.out.println("help                     Print this message.");
                    System.out.println("listen <port>            Set the port you are listening on.");
                    System.out.println("query <string>           Send a query to the network.");
                    System.out.println("quit                     Quit the application.");
                    System.out.println("update                   Send pings to update the statistics.");
                } else {
                    if (command.equals("quit")) break;
                    if (command.equals("stat")) {
                        System.out.println("Number of hosts: " + RouterService.getNumHosts());
                        System.out.println("Number of files: " + RouterService.getNumFiles());
                        System.out.println("Size of files: " + RouterService.getTotalFileSize());
                    } else if (command.equals("update")) {
                        RouterService.updateHorizon();
                    }
                }
                String[] commands = Main.split(command);
                if (commands.length >= 2 && commands[0].equals("connect")) {
                    try {
                        int port = 6346;
                        if (commands.length >= 3) {
                            port = Integer.parseInt(commands[2]);
                        }
                        RouterService.connectToHostBlocking(commands[1], port);
                    }
                    catch (IOException e) {
                        System.out.println("Couldn't establish connection.");
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Please specify a valid port.");
                    }
                    continue;
                }
                if (commands.length >= 2 && commands[0].equals("query")) {
                    int i = command.indexOf(32);
                    Assert.that(i != -1 && i < command.length());
                    String query = command.substring(i + 1);
                    RouterService.query(RouterService.newQueryGUID(), query);
                    continue;
                }
                if (commands.length != 2 || !commands[0].equals("listen")) continue;
                try {
                    int port = Integer.parseInt(commands[1]);
                    RouterService.setListeningPort(port);
                }
                catch (NumberFormatException e) {
                    System.out.println("Please specify a valid port.");
                }
                catch (IOException e) {
                    System.out.println("Couldn't change port.  Try another value.");
                }
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
        System.out.println("Good bye.");
        RouterService.shutdown();
    }

    public void connectionInitializing(Connection c) {
    }

    public void connectionInitialized(Connection c) {
    }

    public void connectionClosed(Connection c) {
    }

    public void knownHost(Endpoint e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleQueryResult(RemoteFileDesc rfd, HostData data, Set loc) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("Query hit from " + rfd.getHost() + ":" + rfd.getPort() + ":");
            System.out.println("   " + rfd.getFileName());
        }
    }

    public void handleQueryString(String query) {
    }

    public void error(int errorCode) {
        this.error(errorCode, null);
    }

    public void error(Throwable problem, String msg) {
        problem.printStackTrace();
        System.out.println(msg);
    }

    public void error(Throwable problem) {
        problem.printStackTrace();
    }

    public void error(int message, Throwable t) {
        System.out.println("Error: " + message);
        t.printStackTrace();
    }

    public static String[] split(String s) {
        int n = (s = s.trim()).length();
        if (n == 0) {
            return new String[0];
        }
        Vector<String> buf = new Vector<String>();
        int i = 0;
        while (i < n) {
            Assert.that(s.charAt(i) != ' ');
            int j = s.indexOf(32, i + 1);
            if (j == -1) {
                j = n;
            }
            buf.add(s.substring(i, j));
            i = j + 1;
            while (j < n && s.charAt(i) == ' ') {
                ++i;
            }
        }
        String[] ret = new String[buf.size()];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (String)buf.get(i2);
        }
        return ret;
    }

    public boolean overwriteFile(String file) {
        return false;
    }

    public void addDownload(Downloader mgr) {
    }

    public void removeDownload(Downloader mgr) {
    }

    public void addUpload(Uploader mgr) {
    }

    public void removeUpload(Uploader mgr) {
    }

    public void setPort(int port) {
    }

    public int getNumUploads() {
        return 0;
    }

    public void addSharedDirectory(File file, File parent) {
    }

    public void addSharedFile(FileDesc file, File parent) {
    }

    public void handleFileManagerEvent(FileManagerEvent evt) {
    }

    public void handleSharedFileUpdate(File file) {
    }

    public void clearSharedFiles() {
    }

    public void acceptChat(Chatter chat) {
    }

    public void receiveMessage(Chatter chat) {
    }

    public void chatUnavailable(Chatter chatter) {
    }

    public void chatErrorMessage(Chatter chatter, String st) {
    }

    public void downloadsComplete() {
    }

    public void fileManagerLoaded() {
    }

    public User getUserAuthenticationInfo(String host) {
        return null;
    }

    public void uploadsComplete() {
    }

    public void promptAboutCorruptDownload(Downloader dloader) {
        dloader.discardCorruptDownload(false);
    }

    public void restoreApplication() {
    }

    public void showDownloads() {
    }

    public String getHostValue(String key) {
        return null;
    }

    public void browseHostFailed(GUID guid) {
    }

    public void setAnnotateEnabled(boolean enabled) {
    }

    public void notifyUserAboutUpdate(String message, boolean isPro, boolean loc) {
    }

    public void indicateNewVersion() {
    }

    public boolean isQueryAlive(GUID guid) {
        return false;
    }

    public void componentLoading(String component) {
        System.out.println("Loading component: " + component);
    }

    public void addressStateChanged() {
    }
}

