/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.device.DeviceChangeListener;

public class UPnPManager
extends ControlPoint
implements DeviceChangeListener {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$UPnPManager == null ? (class$com$limegroup$gnutella$UPnPManager = UPnPManager.class$("com.limegroup.gnutella.UPnPManager")) : class$com$limegroup$gnutella$UPnPManager);
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String SERVICE_TYPE = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String TCP_PREFIX = "LimeTCP";
    private static final String UDP_PREFIX = "LimeUDP";
    private String _guidSuffix;
    private static final int WAIT_TIME = 3000;
    private static final UPnPManager INSTANCE = new UPnPManager();
    private Device _router;
    private Service _service;
    private Mapping _tcp;
    private Mapping _udp;
    private final Object DEVICE_LOCK = new Object();
    static /* synthetic */ Class class$com$limegroup$gnutella$UPnPManager;

    public static UPnPManager instance() {
        return INSTANCE;
    }

    private UPnPManager() {
        this.addDeviceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        LOG.debug("Starting UPnP Manager.");
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            try {
                return super.start();
            }
            catch (Exception bad) {
                ConnectionSettings.DISABLE_UPNP.setValue(true);
                ErrorService.error(bad);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNATPresent() {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            return this._router != null && this._service != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mappingsExist() {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            return this._tcp != null && this._udp != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getNATAddress() throws UnknownHostException {
        Action getIP;
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            if (!this.isNATPresent()) {
                return null;
            }
            getIP = this._service.getAction("GetExternalIPAddress");
        }
        if (getIP == null) {
            LOG.debug("Couldn't find GetExternalIPAddress action!");
            return null;
        }
        if (!getIP.postControlAction()) {
            LOG.debug("couldn't get our external address");
            return null;
        }
        Argument ret = getIP.getOutputArgumentList().getArgument("NewExternalIPAddress");
        return InetAddress.getByName(ret.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDevice() {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            if (this.isNATPresent()) {
                return;
            }
            try {
                this.DEVICE_LOCK.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceAdded(Device dev) {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Device added: " + dev.getFriendlyName());
            }
            if (this._service != null && this._router != null) {
                LOG.debug("we already have a router");
                return;
            }
            if (dev.getDeviceType().equals(ROUTER_DEVICE) && dev.isRootDevice()) {
                this._router = dev;
            }
            if (this._router == null) {
                LOG.debug("didn't get router device");
                return;
            }
            this.discoverService();
            if (this._service == null) {
                LOG.debug("couldn't find service");
                this._router = null;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found service, router: " + this._router.getFriendlyName() + ", service: " + this._service);
                }
                this.DEVICE_LOCK.notify();
                this.stop();
            }
        }
    }

    private void discoverService() {
        Iterator iter = this._router.getDeviceList().iterator();
        while (iter.hasNext()) {
            Device current = (Device)iter.next();
            if (!current.getDeviceType().equals(WAN_DEVICE)) continue;
            DeviceList l = current.getDeviceList();
            if (LOG.isDebugEnabled()) {
                LOG.debug("found " + current.getDeviceType() + ", size: " + l.size() + ", on: " + current.getFriendlyName());
            }
            for (int i = 0; i < current.getDeviceList().size(); ++i) {
                Device current2 = l.getDevice(i);
                if (!current2.getDeviceType().equals(WANCON_DEVICE)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found " + current2.getDeviceType() + ", on: " + current2.getFriendlyName());
                }
                this._service = current2.getService(SERVICE_TYPE);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mapPort(int port) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to map port: " + port);
        }
        Random gen = null;
        String localAddress = NetworkUtils.ip2string(RouterService.getAcceptor().getAddress(false));
        int localPort = port;
        Mapping udp = new Mapping("", port, localAddress, localPort, "UDP", UDP_PREFIX + this.getGUIDSuffix());
        int tries = 20;
        while (!this.addMapping(udp) && tries >= 0) {
            --tries;
            if (gen == null) {
                gen = new Random();
            }
            port = gen.nextInt(50000) + 2000;
            udp = new Mapping("", port, localAddress, localPort, "UDP", UDP_PREFIX + this.getGUIDSuffix());
        }
        if (tries < 0) {
            LOG.debug("couldn't map a port :(");
            return 0;
        }
        Mapping tcp = new Mapping("", port, localAddress, localPort, "TCP", TCP_PREFIX + this.getGUIDSuffix());
        if (!this.addMapping(tcp)) {
            LOG.debug(" couldn't map tcp to whatever udp was mapped. cleaning up...");
            port = 0;
            tcp = null;
            udp = null;
        }
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            this._tcp = tcp;
            this._udp = udp;
        }
        ManagedThread staleCleaner = new ManagedThread(new StaleCleaner());
        staleCleaner.setDaemon(true);
        staleCleaner.setName("Stale Mapping Cleaner");
        staleCleaner.start();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMapping(Mapping m) {
        Action add;
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding " + m);
        }
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            add = this._service.getAction("AddPortMapping");
        }
        if (add == null) {
            LOG.debug("Couldn't find AddPortMapping action!");
            return false;
        }
        add.setArgumentValue("NewRemoteHost", m._externalAddress);
        add.setArgumentValue("NewExternalPort", m._externalPort);
        add.setArgumentValue("NewInternalClient", m._internalAddress);
        add.setArgumentValue("NewInternalPort", m._internalPort);
        add.setArgumentValue("NewProtocol", m._protocol);
        add.setArgumentValue("NewPortMappingDescription", m._description);
        add.setArgumentValue("NewEnabled", "1");
        add.setArgumentValue("NewLeaseDuration", 0);
        boolean success = add.postControlAction();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Post succeeded: " + success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMapping(Mapping m) {
        Action remove;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing " + m);
        }
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            remove = this._service.getAction("DeletePortMapping");
        }
        if (remove == null) {
            LOG.debug("Couldn't find DeletePortMapping action!");
            return false;
        }
        remove.setArgumentValue("NewRemoteHost", m._externalAddress);
        remove.setArgumentValue("NewExternalPort", m._externalPort);
        remove.setArgumentValue("NewProtocol", m._protocol);
        boolean success = remove.postControlAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove succeeded: " + success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMappingsOnShutdown() {
        Mapping udp;
        Mapping tcp;
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            tcp = this._tcp;
            udp = this._udp;
        }
        Thread waiter = new Thread("UPnP Waiter"){

            public void run() {
                Thread cleaner = new Thread(this, "UPnP Cleaner"){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        UPnPManager.access$100().debug("start cleaning");
                        UPnPManager.access$400(1.access$300(this.this$1), 1.access$200(this.this$1));
                        UPnPManager.access$400(1.access$300(this.this$1), 1.access$500(this.this$1));
                        UPnPManager.access$100().debug("done cleaning");
                    }
                };
                cleaner.setDaemon(true);
                cleaner.start();
                Thread.yield();
                try {
                    LOG.debug("waiting for UPnP cleaners to finish");
                    cleaner.join(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.debug("UPnP cleaners done");
            }

            static /* synthetic */ Mapping access$200(1 x0) {
                return x0.tcp;
            }

            static /* synthetic */ UPnPManager access$300(1 x0) {
                return x0.UPnPManager.this;
            }

            static /* synthetic */ Mapping access$500(1 x0) {
                return x0.udp;
            }
        };
        RouterService.addShutdownItem(waiter);
    }

    public void finalize() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGUIDSuffix() {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            if (this._guidSuffix == null) {
                this._guidSuffix = ApplicationSettings.CLIENT_ID.getValue().substring(0, 10);
            }
            return this._guidSuffix;
        }
    }

    public void deviceRemoved(Device dev) {
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        if (addr instanceof Inet4Address && !addr.isLoopbackAddress()) {
            return addr;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        addr = addresses.nextElement();
                        if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                        return addr;
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        throw new UnknownHostException("localhost has no interface with a non-loopback IPv4 address");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StaleCleaner
    implements Runnable {
        private StaleCleaner() {
        }

        private String list(List l) {
            String s = "";
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Argument next = (Argument)i.next();
                s = s + next.getName() + "->" + next.getValue() + ", ";
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Action getGeneric;
            LOG.debug("Looking for stale mappings...");
            HashSet<Mapping> mappings = new HashSet<Mapping>();
            Object object = UPnPManager.this.DEVICE_LOCK;
            synchronized (object) {
                getGeneric = UPnPManager.this._service.getAction("GetGenericPortMappingEntry");
            }
            if (getGeneric == null) {
                LOG.debug("Couldn't find GetGenericPortMappingEntry action!");
                return;
            }
            try {
                int i = 0;
                while (true) {
                    getGeneric.setArgumentValue("NewPortMappingIndex", i);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stale Iteration: " + i + ", generic.input: " + this.list(getGeneric.getInputArgumentList()) + ", generic.output: " + this.list(getGeneric.getOutputArgumentList()));
                    }
                    if (getGeneric.postControlAction()) {
                        mappings.add(new Mapping(getGeneric.getArgumentValue("NewRemoteHost"), getGeneric.getArgumentValue("NewExternalPort"), getGeneric.getArgumentValue("NewInternalClient"), getGeneric.getArgumentValue("NewInternalPort"), getGeneric.getArgumentValue("NewProtocol"), getGeneric.getArgumentValue("NewPortMappingDescription")));
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException bad) {
                LOG.error("NFE reading mappings!", bad);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stale cleaner found " + mappings.size() + " total mappings");
            }
            Iterator iter = mappings.iterator();
            while (iter.hasNext()) {
                Mapping current = (Mapping)iter.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Analyzing: " + current);
                }
                if (current._description == null || !current._description.equals(UPnPManager.TCP_PREFIX + UPnPManager.this.getGUIDSuffix()) && !current._description.equals(UPnPManager.UDP_PREFIX + UPnPManager.this.getGUIDSuffix())) continue;
                Object object2 = UPnPManager.this.DEVICE_LOCK;
                synchronized (object2) {
                    if (UPnPManager.this._tcp != null && UPnPManager.this._udp != null && current._externalPort == ((UPnPManager)UPnPManager.this)._tcp._externalPort && current._internalAddress.equals(((UPnPManager)UPnPManager.this)._tcp._internalAddress) && current._internalPort == ((UPnPManager)UPnPManager.this)._tcp._internalPort) {
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("mapping " + current + " appears to be stale");
                }
                UPnPManager.this.removeMapping(current);
            }
        }
    }

    private final class Mapping {
        public final String _externalAddress;
        public final int _externalPort;
        public final String _internalAddress;
        public final int _internalPort;
        public final String _protocol;
        public final String _description;

        public Mapping(String externalAddress, String externalPort, String internalAddress, String internalPort, String protocol, String description) throws NumberFormatException {
            this._externalAddress = externalAddress;
            this._externalPort = Integer.parseInt(externalPort);
            this._internalAddress = internalAddress;
            this._internalPort = Integer.parseInt(internalPort);
            this._protocol = protocol;
            this._description = description;
        }

        public Mapping(String externalAddress, int externalPort, String internalAddress, int internalPort, String protocol, String description) {
            if (!NetworkUtils.isValidPort(externalPort) || !NetworkUtils.isValidPort(internalPort)) {
                throw new IllegalArgumentException();
            }
            this._externalAddress = externalAddress;
            this._externalPort = externalPort;
            this._internalAddress = internalAddress;
            this._internalPort = internalPort;
            this._protocol = protocol;
            this._description = description;
        }

        public String toString() {
            return this._externalAddress + ":" + this._externalPort + "->" + this._internalAddress + ":" + this._internalPort + "@" + this._protocol + " desc: " + this._description;
        }
    }
}

