/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.dime.DIMEMessageException;
import com.limegroup.gnutella.util.DataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DIMERecord {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$dime$DIMERecord == null ? (class$com$limegroup$gnutella$dime$DIMERecord = DIMERecord.class$("com.limegroup.gnutella.dime.DIMERecord")) : class$com$limegroup$gnutella$dime$DIMERecord);
    public static final byte VERSION = 8;
    private static final byte VERSION_MASK = -8;
    private static final byte MB_MASK = 4;
    private static final byte ME_MASK = 2;
    private static final byte CF_MASK = 1;
    private byte _byte1;
    public static final byte TYPE_UNCHANGED = 0;
    public static final byte TYPE_MEDIA_TYPE = 16;
    public static final byte TYPE_ABSOLUTE_URI = 32;
    public static final byte TYPE_UNKNOWN = 48;
    public static final byte TYPE_NONE = 64;
    private static final byte TYPE_MASK = -16;
    private static final byte RESERVED = 0;
    private static final byte RESERVED_MASK = 15;
    private final byte _byte2;
    private final byte[] _options;
    private final byte[] _id;
    private final byte[] _type;
    private final byte[] _data;
    private String _idString = null;
    private Map _optionsMap = null;
    static /* synthetic */ Class class$com$limegroup$gnutella$dime$DIMERecord;

    public DIMERecord(byte byte1, byte byte2, byte[] options, byte[] id, byte[] type, byte[] data) {
        this._byte1 = byte1;
        this._byte2 = byte2;
        if (options == null) {
            options = DataUtils.EMPTY_BYTE_ARRAY;
        }
        if (id == null) {
            id = DataUtils.EMPTY_BYTE_ARRAY;
        }
        if (type == null) {
            type = DataUtils.EMPTY_BYTE_ARRAY;
        }
        if (data == null) {
            data = DataUtils.EMPTY_BYTE_ARRAY;
        }
        this._options = options;
        this._id = id;
        this._type = type;
        this._data = data;
        this.validate();
    }

    public DIMERecord(byte typeId, byte[] options, byte[] id, byte[] type, byte[] data) {
        this(8, (byte)(typeId | 0), options, id, type, data);
    }

    public static DIMERecord createFromStream(InputStream in) throws IOException {
        byte[] header = new byte[12];
        DIMERecord.fillBuffer(header, in);
        try {
            DIMERecord.validateFirstBytes(header[0], header[1]);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
        int optionsLength = ByteOrder.beb2int(header, 2, 2);
        int idLength = ByteOrder.beb2int(header, 4, 2);
        int typeLength = ByteOrder.beb2int(header, 6, 2);
        int dataLength = ByteOrder.beb2int(header, 8, 4);
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating dime record.  optionsLength: " + optionsLength + ", idLength: " + idLength + ", typeLength: " + typeLength + ", dataLength: " + dataLength);
        }
        if (dataLength < 0) {
            throw new IOException("data too big.");
        }
        byte[] options = DIMERecord.readInformation(optionsLength, in);
        byte[] id = DIMERecord.readInformation(idLength, in);
        byte[] type = DIMERecord.readInformation(typeLength, in);
        byte[] data = DIMERecord.readInformation(dataLength, in);
        try {
            return new DIMERecord(header[0], header[1], options, id, type, data);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
    }

    public int getRecordLength() {
        return 12 + this.getOptionsLength() + DIMERecord.calculatePaddingLength(this.getOptionsLength()) + this.getIdLength() + DIMERecord.calculatePaddingLength(this.getIdLength()) + this.getTypeLength() + DIMERecord.calculatePaddingLength(this.getTypeLength()) + this.getDataLength() + DIMERecord.calculatePaddingLength(this.getDataLength());
    }

    void write(OutputStream out) throws IOException {
        out.write(this._byte1);
        out.write(this._byte2);
        ByteOrder.int2beb(this.getOptionsLength(), out, 2);
        ByteOrder.int2beb(this.getIdLength(), out, 2);
        ByteOrder.int2beb(this.getTypeLength(), out, 2);
        ByteOrder.int2beb(this.getDataLength(), out, 4);
        this.writeOptions(out);
        this.writeId(out);
        this.writeType(out);
        this.writeData(out);
    }

    public void writeOptions(OutputStream out) throws IOException {
        DIMERecord.writeDataWithPadding(this._options, out);
    }

    public void writeId(OutputStream out) throws IOException {
        DIMERecord.writeDataWithPadding(this._id, out);
    }

    public void writeType(OutputStream out) throws IOException {
        DIMERecord.writeDataWithPadding(this._type, out);
    }

    public void writeData(OutputStream out) throws IOException {
        DIMERecord.writeDataWithPadding(this._data, out);
    }

    public void setFirstRecord(boolean first) {
        this._byte1 = first ? (byte)(this._byte1 | 4) : (byte)(this._byte1 & 0xFFFFFFFB);
    }

    public boolean isFirstRecord() {
        return (this._byte1 & 4) == 4;
    }

    public void setLastRecord(boolean last) {
        this._byte1 = last ? (byte)(this._byte1 | 2) : (byte)(this._byte1 & 0xFFFFFFFD);
    }

    public boolean isLastRecord() {
        return (this._byte1 & 2) == 2;
    }

    public int getTypeId() {
        return this._byte2 & 0xFFFFFFF0;
    }

    public int getTypeLength() {
        return this._type.length;
    }

    public byte[] getType() {
        return this._type;
    }

    public String getTypeString() {
        try {
            return new String(this.getType(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ErrorService.error(e);
            return null;
        }
    }

    public int getDataLength() {
        return this._data.length;
    }

    public byte[] getData() {
        return this._data;
    }

    public int getIdLength() {
        return this._id.length;
    }

    public byte[] getId() {
        return this._id;
    }

    public int getOptionsLength() {
        return this._options.length;
    }

    public byte[] getOptions() {
        return this._options;
    }

    public String getIdentifier() {
        if (this._idString == null) {
            this._idString = new String(this.getId());
        }
        return this._idString;
    }

    public Map getOptionsMap() throws DIMEMessageException {
        if (this._optionsMap == null) {
            this._optionsMap = DIMERecord.parseOptions(this.getOptions());
        }
        return this._optionsMap;
    }

    public static void writePadding(int length, OutputStream os) throws IOException {
        int padding = DIMERecord.calculatePaddingLength(length);
        switch (padding) {
            case 0: {
                return;
            }
            case 1: {
                os.write(DataUtils.BYTE_ARRAY_ONE);
                return;
            }
            case 2: {
                os.write(DataUtils.BYTE_ARRAY_TWO);
                return;
            }
            case 3: {
                os.write(DataUtils.BYTE_ARRAY_THREE);
                return;
            }
        }
        throw new IllegalStateException("invalid padding.");
    }

    private static void validateFirstBytes(byte one, byte two) {
        if ((one & 0xFFFFFFF8) != 8) {
            throw new IllegalArgumentException("invalid version: " + ((one & 0xFFFFFFF8) >> 3 & 0x1F));
        }
        if ((two & 0xF) != 0) {
            throw new IllegalArgumentException("invalid reserved: " + (two & 0xF));
        }
    }

    private void validate() {
        DIMERecord.validateFirstBytes(this._byte1, this._byte2);
        byte maskedType = (byte)(this._byte2 & 0xFFFFFFF0);
        switch (maskedType) {
            case 0: {
                if (this.getTypeLength() == 0) break;
                throw new IllegalArgumentException("TYPE_UNCHANGED requires 0 type length");
            }
            case 16: {
                break;
            }
            case 32: {
                break;
            }
            case 48: {
                if (this.getTypeLength() == 0) break;
                throw new IllegalArgumentException("TYPE_UNKNOWN requires 0 type length");
            }
            case 64: {
                if (this.getTypeLength() == 0 && this.getDataLength() == 0) break;
                throw new IllegalArgumentException("TYPE_NONE requires 0 type & data length");
            }
            default: {
                throw new IllegalArgumentException("invalid type: " + (maskedType >> 4 & 0xF));
            }
        }
    }

    private static byte[] readInformation(int length, InputStream in) throws IOException {
        if (length == 0) {
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] info = new byte[length];
        DIMERecord.fillBuffer(info, in);
        DIMERecord.skipPaddedData(length, in);
        return info;
    }

    private static void writeDataWithPadding(byte[] data, OutputStream os) throws IOException {
        if (data.length == 0) {
            return;
        }
        os.write(data);
        DIMERecord.writePadding(data.length, os);
    }

    private static int calculatePaddingLength(int length) {
        return length % 4 == 0 ? 0 : 4 - length % 4;
    }

    private static void skipPaddedData(int length, InputStream in) throws IOException {
        long current;
        int padding = DIMERecord.calculatePaddingLength(length);
        for (long skipped = 0L; skipped < (long)padding; skipped += current) {
            current = in.skip((long)padding - skipped);
            if (current != -1L && current != 0L) continue;
            throw new IOException("eof");
        }
    }

    private static void fillBuffer(byte[] buffer, InputStream in) throws IOException {
        int read;
        for (int offset = 0; offset < buffer.length; offset += read) {
            read = in.read(buffer, offset, buffer.length - offset);
            if (read != -1) continue;
            throw new IOException("eof");
        }
    }

    private static Map parseOptions(byte[] options) throws DIMEMessageException {
        int valueLength;
        HashMap<String, String> map = new HashMap<String, String>();
        for (int offset = 0; offset < options.length; offset += valueLength) {
            String value;
            String key;
            if (options.length - offset < 4) {
                throw new DIMEMessageException("illegal options field");
            }
            byte[] keyBytes = new byte[2];
            System.arraycopy(options, offset, keyBytes, 0, 2);
            try {
                key = new String(keyBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                key = null;
            }
            valueLength = ByteOrder.beb2int(options, offset += 2, 2);
            if (options.length - (offset += 2) < valueLength) {
                throw new DIMEMessageException("illegal options field");
            }
            byte[] valueBytes = new byte[valueLength];
            System.arraycopy(options, offset, valueBytes, 0, valueLength);
            try {
                value = new String(valueBytes, "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                value = null;
            }
            if (key == null || value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

