/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ByteOrder;
import java.io.Serializable;

public class Interval
implements Serializable {
    static final long serialVersionUID = -2562093104400487554L;
    public final int low;
    public final int high;

    public Interval(int low, int high) {
        if (high < low) {
            throw new IllegalArgumentException("low: " + low + ", high: " + high);
        }
        this.low = low;
        this.high = high;
    }

    public Interval(int singleton) {
        this.low = singleton;
        this.high = singleton;
    }

    public boolean isSubrange(Interval other) {
        return this.low >= other.low && this.high <= other.high;
    }

    public String toString() {
        if (this.low == this.high) {
            return String.valueOf(this.low);
        }
        return String.valueOf(this.low) + "-" + String.valueOf(this.high);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)o;
        return this.low == other.low && this.high == other.high;
    }

    public byte[] toBytes() {
        byte[] res = new byte[8];
        ByteOrder.int2beb(this.low, res, 0);
        ByteOrder.int2beb(this.high, res, 4);
        return res;
    }
}

