/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.gui.GUIMediator;
import javax.swing.SwingUtilities;

public final class GURLHandler {
    private static final GURLHandler INSTANCE;
    private boolean isRegistered = false;

    private GURLHandler() throws UnsatisfiedLinkError {
    }

    public static GURLHandler getInstance() {
        return INSTANCE;
    }

    private void callback(final String url) {
        if (ExternalControl.isInitialized()) {
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        ExternalControl.handleMagnetRequest(url);
                    }
                    catch (Throwable t) {
                        GUIMediator.showInternalError(t);
                    }
                }
            };
            SwingUtilities.invokeLater(runner);
        } else {
            ExternalControl.enqueueMagnetRequest(url);
        }
    }

    public void register() {
        if (!this.isRegistered && this.InstallEventHandler() == 0) {
            this.isRegistered = true;
        }
    }

    protected void finalize() throws Throwable {
        if (this.isRegistered) {
            this.RemoveEventHandler();
        }
    }

    private final synchronized native int InstallEventHandler();

    private final synchronized native int RemoveEventHandler();

    static {
        System.loadLibrary("GURL");
        INSTANCE = new GURLHandler();
    }
}

