/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;

public class IconManager {
    private static IconManager INSTANCE = new IconManager();
    private final FileView VIEW;
    private final Map EXTENSIONS = new HashMap();
    private final Icon NULL = new ImageIcon();
    private final boolean REQUIRES_FILE;
    private final Properties BUTTON_NAMES = IconManager.loadButtonNameMap();
    private final Map BUTTON_CACHE = new HashMap();

    public static IconManager instance() {
        return INSTANCE;
    }

    private IconManager() {
        FileView view = null;
        boolean requiresFile = false;
        if (CommonUtils.isMacOSX() || CommonUtils.isWindows() && CommonUtils.isJava14OrLater()) {
            requiresFile = true;
            view = this.getNativeFileView();
        }
        if (view == null) {
            requiresFile = false;
            view = new MediaFileView();
        } else {
            requiresFile = true;
            view = new DelegateFileView(view);
        }
        this.VIEW = view;
        this.REQUIRES_FILE = requiresFile;
        if (!(view instanceof MediaFileView)) {
            this.preload();
        }
    }

    private FileView getNativeFileView() {
        JFileChooser chooser = null;
        for (int i = 0; i < 10; ++i) {
            try {
                chooser = new JFileChooser(){
                    {
                        FileChooserUI ui = (FileChooserUI)ResourceManager.getNativeUI(this);
                        this.setUI(ui);
                        this.setFileView(ui.getFileView(this));
                    }
                };
                break;
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
        }
        if (chooser == null) {
            return null;
        }
        return chooser.getFileView();
    }

    public Icon getIconForFile(File f) {
        if (f == null) {
            return null;
        }
        if (this.REQUIRES_FILE && f.exists()) {
            return this.VIEW.getIcon(f);
        }
        String extension = FileUtils.getFileExtension(f);
        if (extension != null) {
            return this.getIconForExtension(extension);
        }
        return null;
    }

    public Icon getIconForExtension(String ext) {
        if (!this.REQUIRES_FILE) {
            return this.VIEW.getIcon(new File("a." + ext));
        }
        Icon icon = (Icon)this.EXTENSIONS.get(ext = ext.toLowerCase());
        if (icon != null) {
            if (icon != this.NULL) {
                return icon;
            }
            return null;
        }
        File dir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        File tmp = new File(dir, ".LimeWireIconFinder." + ext);
        if (tmp.exists()) {
            icon = this.VIEW.getIcon(tmp);
        } else {
            try {
                FileUtils.touch(tmp);
                icon = this.VIEW.getIcon(tmp);
                if (icon == null) {
                    icon = this.NULL;
                }
            }
            catch (IOException fnfe) {
                icon = this.NULL;
            }
        }
        tmp.delete();
        this.EXTENSIONS.put(ext, icon);
        return icon;
    }

    public void wipeButtonIconCache() {
        this.BUTTON_CACHE.clear();
    }

    public Icon getIconForButton(String buttonName) {
        String fileName = (String)this.BUTTON_NAMES.get(buttonName);
        if (fileName == null) {
            return null;
        }
        ImageIcon icon = (ImageIcon)this.BUTTON_CACHE.get(fileName);
        if (icon == this.NULL) {
            return null;
        }
        if (icon != null) {
            return icon;
        }
        try {
            String retrieveName = UISettings.SMALL_ICONS.getValue() ? fileName + "_small" : fileName + "_large";
            icon = ResourceManager.getThemeImage(retrieveName);
            this.BUTTON_CACHE.put(fileName, icon);
        }
        catch (MissingResourceException mre) {
            try {
                icon = ResourceManager.getThemeImage(fileName);
                this.BUTTON_CACHE.put(fileName, icon);
            }
            catch (MissingResourceException mre2) {
                this.BUTTON_CACHE.put(fileName, this.NULL);
            }
        }
        return icon;
    }

    public Icon getRolloverIconForButton(String buttonName) {
        String fileName = (String)this.BUTTON_NAMES.get(buttonName);
        if (fileName == null) {
            return null;
        }
        String rolloverName = fileName + "_rollover";
        Icon rollover = (Icon)this.BUTTON_CACHE.get(rolloverName);
        if (rollover == this.NULL) {
            return null;
        }
        if (rollover != null) {
            return rollover;
        }
        Icon icon = (Icon)this.BUTTON_CACHE.get(fileName);
        if (icon == this.NULL || icon == null) {
            this.BUTTON_CACHE.put(rolloverName, this.NULL);
            return null;
        }
        rollover = ImageManipulator.brighten(icon);
        if (rollover == null) {
            this.BUTTON_CACHE.put(rolloverName, this.NULL);
        } else {
            this.BUTTON_CACHE.put(rolloverName, rollover);
        }
        return rollover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties loadButtonNameMap() {
        BufferedInputStream is;
        Properties p;
        block8: {
            p = new Properties();
            URL url = ResourceManager.getURLResource("icon_mapping.properties");
            is = null;
            if (url == null) break block8;
            is = new BufferedInputStream(url.openStream());
            p.load(is);
        }
        Object var5_3 = null;
        if (is == null) return p;
        try {
            ((InputStream)is).close();
            return p;
        }
        catch (IOException ignored) {}
        return p;
        {
            catch (IOException iOException) {
                Object var5_4 = null;
                if (is == null) return p;
                try {
                    ((InputStream)is).close();
                    return p;
                }
                catch (IOException ignored) {}
                return p;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void preload() {
        ProcessingQueue queue = new ProcessingQueue("IconLoader");
        MediaType[] types = MediaType.getDefaultMediaTypes();
        for (int i = 0; i < types.length; ++i) {
            Set exts = types[i].getExtensions();
            Iterator j = exts.iterator();
            while (j.hasNext()) {
                final String next = (String)j.next();
                queue.add(new Runnable(){

                    public void run() {
                        GUIMediator.safeInvokeAndWait(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                2.access$200(this.this$1).getIconForExtension(2.access$100(this.this$1));
                            }
                        });
                    }

                    static /* synthetic */ String access$100(2 x0) {
                        return x0.next;
                    }

                    static /* synthetic */ IconManager access$200(2 x0) {
                        return x0.IconManager.this;
                    }
                });
            }
        }
    }

    private static class NullFileView
    extends FileView {
        private NullFileView() {
        }

        public String getDescription(File f) {
            return null;
        }

        public Icon getIcon(File f) {
            return null;
        }

        public String getName(File f) {
            return null;
        }

        public String getTypeDescription(File f) {
            return null;
        }

        public Boolean isTraversable(File f) {
            return Boolean.FALSE;
        }
    }

    private static class DelegateFileView
    extends FileView {
        private final FileView DELEGATE;

        DelegateFileView(FileView real) {
            this.DELEGATE = real;
        }

        public Icon getIcon(File f) {
            try {
                return this.DELEGATE.getIcon(f);
            }
            catch (NullPointerException npe) {
                return null;
            }
        }

        public String getDescription(File f) {
            return this.DELEGATE.getDescription(f);
        }

        public String getName(File f) {
            return this.DELEGATE.getName(f);
        }

        public String getTypeDescription(File f) {
            return this.DELEGATE.getTypeDescription(f);
        }

        public Boolean isTraversable(File f) {
            return this.DELEGATE.isTraversable(f);
        }
    }

    private static class MediaFileView
    extends FileView {
        private MediaFileView() {
        }

        public Icon getIcon(File f) {
            String ext = FileUtils.getFileExtension(f);
            NamedMediaType nmt = null;
            if (ext != null) {
                nmt = NamedMediaType.getFromExtension(ext);
            }
            if (nmt == null) {
                nmt = NamedMediaType.getFromDescription("*");
            }
            return nmt.getIcon();
        }

        public String getDescription(File f) {
            return null;
        }

        public String getName(File f) {
            return null;
        }

        public String getTypeDescription(File f) {
            return null;
        }

        public Boolean isTraversable(File f) {
            return Boolean.FALSE;
        }
    }
}

