/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.FontMetrics;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;

public class MultiLineLabel
extends JTextArea {
    private static final int DEFAULT_LABEL_WIDTH = 200;
    private String _theText;

    public MultiLineLabel(String s) {
        if (s == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(s);
    }

    public MultiLineLabel(String s, int pixels) {
        if (s == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(s, pixels);
    }

    public MultiLineLabel(String[] strs) {
        this.setOpaque(false);
        this._theText = this.createSizedString(strs);
        super.setText(this._theText);
    }

    public MultiLineLabel(String s, int pixels, int rows, int cols) {
        super(rows, cols);
        if (s == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(s, pixels);
    }

    public void setText(String s, int pixels) {
        this._theText = s;
        super.setText(this.createSizedString(s, pixels));
    }

    public void setText(String s) {
        this._theText = s;
        super.setText(this.createSizedString(s, 200));
    }

    public String getText() {
        return this._theText;
    }

    public void updateUI() {
        super.updateUI();
        this.setWrapStyleWord(true);
        this.setHighlighter(null);
        this.setEditable(false);
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
    }

    private String createSizedString(String message, int pixels) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        StringTokenizer st = new StringTokenizer(message, " \n", true);
        StringBuffer sb = new StringBuffer();
        StringBuffer cursb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (word.equals(" ")) continue;
            boolean isNewLine = word.equals("\n");
            if (isNewLine || fm.stringWidth(cursb.toString() + word) > pixels) {
                sb.append(cursb.toString());
                sb.append("\n");
                cursb = new StringBuffer();
            }
            if (isNewLine) continue;
            cursb.append(word);
            cursb.append(" ");
        }
        sb.append(cursb.toString());
        return sb.toString();
    }

    private String createSizedString(String[] strs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            sb.append(strs[i]);
            sb.append("\n");
        }
        return sb.toString();
    }
}

