/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.init.BackButton;
import com.limegroup.gnutella.gui.init.CancelButton;
import com.limegroup.gnutella.gui.init.FinishButton;
import com.limegroup.gnutella.gui.init.NextButton;
import com.limegroup.gnutella.gui.init.SetupButtonPanel;
import com.limegroup.gnutella.gui.init.SetupManager;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JPanel;

final class SetupButtons
extends JPanel {
    private final int BUTTON_SEP = 6;
    private final String STANDARD_BUTTON_TITLE = "Standard Buttons";
    private final String NEXT_BUTTON_TITLE = "Next";
    private final String FINISH_BUTTON_TITLE = "Finish Button";
    private final String CANCEL_BUTTON_TITLE = "Cancel Button";
    private final CardLayout CARD_LAYOUT = new CardLayout();
    private boolean _standardButtonsShown = true;

    SetupButtons(SetupManager manager) {
        this.setLayout(this.CARD_LAYOUT);
        this.reconstruct(manager);
    }

    void reconstruct(SetupManager manager) {
        SetupButtonPanel standardButtonPanel = new SetupButtonPanel();
        SetupButtonPanel finishButtonPanel = new SetupButtonPanel();
        SetupButtonPanel cancelButtonPanel = new SetupButtonPanel();
        SetupButtonPanel nextButtonPanel = new SetupButtonPanel();
        BackButton backButton = new BackButton(manager);
        NextButton nextButton = new NextButton(manager);
        CancelButton cancelButton = new CancelButton(manager);
        standardButtonPanel.add(Box.createHorizontalGlue());
        standardButtonPanel.add(backButton);
        standardButtonPanel.add(Box.createHorizontalStrut(6));
        standardButtonPanel.add(nextButton);
        standardButtonPanel.add(Box.createHorizontalStrut(12));
        standardButtonPanel.add(cancelButton);
        NextButton nextButton1 = new NextButton(manager);
        CancelButton cancelButton1 = new CancelButton(manager);
        nextButtonPanel.add(Box.createHorizontalGlue());
        nextButtonPanel.add(nextButton1);
        nextButtonPanel.add(Box.createHorizontalStrut(12));
        nextButtonPanel.add(cancelButton1);
        FinishButton finishButton = new FinishButton(manager);
        finishButtonPanel.add(Box.createHorizontalGlue());
        finishButtonPanel.add(finishButton);
        CancelButton cancelButton2 = new CancelButton(manager);
        cancelButtonPanel.add(Box.createHorizontalGlue());
        cancelButtonPanel.add(cancelButton2);
        this.removeAll();
        this.add((Component)standardButtonPanel, "Standard Buttons");
        this.add((Component)finishButtonPanel, "Finish Button");
        this.add((Component)cancelButtonPanel, "Cancel Button");
        this.add((Component)nextButtonPanel, "Next");
    }

    void goToStandardButtons() {
        if (!this._standardButtonsShown) {
            this.CARD_LAYOUT.show(this, "Standard Buttons");
            this._standardButtonsShown = true;
        }
    }

    void goToFinishButtons() {
        this.CARD_LAYOUT.show(this, "Finish Button");
        this._standardButtonsShown = false;
    }

    void goToCancelButtons() {
        this.CARD_LAYOUT.show(this, "Cancel Button");
        this._standardButtonsShown = false;
    }

    void goToNextButtons() {
        this.CARD_LAYOUT.show(this, "Next");
        this._standardButtonsShown = false;
    }
}

