/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.library.ExploreListener;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.library.RefreshListener;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

final class LibraryConstructor {
    private final PaddedPanel MAIN_PANEL = new PaddedPanel();
    private final ButtonRow _mainButtons;
    private final JScrollPane TREE_SCROLL_PANE;

    LibraryConstructor(LibraryTableMediator libraryTable, LibraryTree libraryTree) {
        String libraryTitle = GUIMediator.getStringResource("LIBRARY_TITLE");
        this.MAIN_PANEL.setTitle(libraryTitle);
        this.TREE_SCROLL_PANE = new JScrollPane(libraryTree.getTree());
        Box splitBox = new Box(0);
        JSplitPane splitPane = new JSplitPane(1, this.TREE_SCROLL_PANE, libraryTable.getScrolledTablePane());
        splitPane.setDividerLocation(150);
        splitPane.setOneTouchExpandable(true);
        splitBox.add(splitPane);
        this._mainButtons = libraryTable.getButtonRow();
        String[] refreshKey = new String[]{"LIBRARY_REFRESH_BUTTON_LABEL"};
        String[] refreshTip = new String[]{"LIBRARY_REFRESH_BUTTON_TIP"};
        ActionListener[] refreshListener = new ActionListener[]{new RefreshListener()};
        String[] refreshName = new String[]{"LIBRARY_REFRESH"};
        ButtonRow refreshButton = new ButtonRow(refreshKey, refreshTip, refreshListener, refreshName);
        String[] exploreKey = new String[]{"LIBRARY_EXPLORE_BUTTON_LABEL"};
        String[] exploreTip = new String[]{"LIBRARY_EXPLORE_BUTTON_TIP"};
        ActionListener[] exploreListener = new ActionListener[]{new ExploreListener()};
        String[] exploreName = new String[]{"LIBRARY_EXPLORE"};
        ButtonRow exploreButton = new ButtonRow(exploreKey, exploreTip, exploreListener, exploreName);
        BoxPanel buttonPanel = new BoxPanel(0);
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(refreshButton);
        if (CommonUtils.isWindows() || CommonUtils.isMacOSX()) {
            p.add(exploreButton);
        }
        buttonPanel.add(p);
        p = new JPanel(new FlowLayout(0));
        p.add(this._mainButtons);
        buttonPanel.add(p);
        this.MAIN_PANEL.add(splitBox);
        this.MAIN_PANEL.add(Box.createVerticalStrut(6));
        this.MAIN_PANEL.add(buttonPanel);
        this.updateTheme();
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.TREE_SCROLL_PANE.getViewport().setBackground(tableColor);
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }
}

