/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.ExploreListener;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

final class FileMenu
extends AbstractMenu {
    FileMenu(String key) {
        super(key);
        this.handleStandardSelection();
    }

    private JMenuItem getMenuItem(String key, ActionListener listener) {
        String label = GUIMediator.getStringResource(key);
        String accessibleLabel = GUIMediator.getStringResource(key + "_ACCESSIBLE");
        int mnemonic = this.getCodeForCharKey(key + "_MNEMONIC");
        JMenuItem menuItem = new JMenuItem(label, mnemonic);
        menuItem.getAccessibleContext().setAccessibleDescription(accessibleLabel);
        menuItem.addActionListener(listener);
        menuItem.setFont(AbstractMenu.FONT);
        return menuItem;
    }

    void handleLibrarySelection() {
        this.MENU.removeAll();
        this.MENU.add(this.getMenuItem("MENU_FILE_CONNECT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().connect();
            }
        }));
        this.MENU.add(this.getMenuItem("MENU_FILE_DISCONNECT", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().disconnect();
            }
        }));
        this.MENU.addSeparator();
        this.MENU.add(this.getMenuItem("MENU_FILE_LIBRARY_ADD_SHARED_FOLDER", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().addSharedLibraryFolder();
            }
        }));
        this.MENU.add(this.getMenuItem("MENU_FILE_LIBRARY_UNSHARE_FOLDER", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().unshareLibraryFolder();
            }
        }));
        this.MENU.addSeparator();
        this.MENU.add(this.getMenuItem("MENU_FILE_LIBRARY_LAUNCH_FILES", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().launchLibraryFile();
            }
        }));
        this.MENU.add(this.getMenuItem("MENU_FILE_LIBRARY_DELETE_FILES", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().deleteLibraryFile();
            }
        }));
        this.MENU.addSeparator();
        this.MENU.add(this.getMenuItem("MENU_FILE_LIBRARY_REFRESH", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().refreshLibrary();
            }
        }));
        if (CommonUtils.isWindows() || CommonUtils.isMacOSX()) {
            this.MENU.add(this.getMenuItem("MENU_FILE_LIBRARY_EXPLORE", new ExploreListener()));
        }
        if (!CommonUtils.isMacOSX()) {
            this.MENU.addSeparator();
            this.MENU.add(this.getMenuItem("MENU_FILE_CLOSE", new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GUIMediator.close(false);
                }
            }));
        }
        this.setConnected(RouterService.isConnected() || RouterService.isConnecting());
    }

    void handleStandardSelection() {
        if (this.MENU.getItemCount() > 1 || this.MENU.getItemCount() == 0) {
            this.MENU.removeAll();
            this.MENU.add(this.getMenuItem("MENU_FILE_CONNECT", new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GUIMediator.instance().connect();
                }
            }));
            this.MENU.add(this.getMenuItem("MENU_FILE_DISCONNECT", new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GUIMediator.instance().disconnect();
                }
            }));
            if (!CommonUtils.isMacOSX()) {
                this.MENU.addSeparator();
                this.MENU.add(this.getMenuItem("MENU_FILE_CLOSE", new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        GUIMediator.close(false);
                    }
                }));
            }
            this.setConnected(RouterService.isConnected() || RouterService.isConnecting());
        }
    }

    void setConnected(boolean connected) {
        this.MENU.getItem(0).setEnabled(!connected);
        this.MENU.getItem(1).setEnabled(connected);
    }
}

