/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LanguageInfo;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

final class LanguageMenu
extends AbstractMenu {
    private static final ActionListener LANGUAGE_CHANGER = new LanguageChangeListener();
    private static final ButtonGroup GROUP = new ButtonGroup();
    private static final String LANGUAGE_PROPERTY = "LANGUAGE";

    LanguageMenu(String key) {
        super(key);
        this.addMenuItem("VIEW_LANGS_TRANSLATE_LIMEWIRE", new TranslateListener());
        this.addSeparator();
        LanguageInfo[] langs = LanguageInfo.getLanguages(AbstractMenu.FONT);
        for (int i = 0; i < langs.length; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(langs[i].toString());
            item.setFont(AbstractMenu.FONT);
            item.putClientProperty(LANGUAGE_PROPERTY, langs[i]);
            item.addActionListener(LANGUAGE_CHANGER);
            if (langs[i].isCurrent()) {
                item.setSelected(true);
            }
            this.MENU.add(item);
            GROUP.add(item);
        }
    }

    protected static class LanguageChangeListener
    implements ActionListener {
        protected LanguageChangeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            LanguageInfo lang = (LanguageInfo)item.getClientProperty(LanguageMenu.LANGUAGE_PROPERTY);
            if (!lang.isCurrent()) {
                lang.apply();
                GUIMediator.showMessage("MENU_VIEW_LANGS_RESTART_REQUIRED");
            }
        }
    }

    private static class TranslateListener
    implements ActionListener {
        private TranslateListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String url = "http://www.limewire.org/translate.shtml";
            GUIMediator.openURL(url);
        }
    }
}

