/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.menu.FileMenu;
import com.limegroup.gnutella.gui.menu.HelpMenu;
import com.limegroup.gnutella.gui.menu.Menu;
import com.limegroup.gnutella.gui.menu.NavMenu;
import com.limegroup.gnutella.gui.menu.ResourcesMenu;
import com.limegroup.gnutella.gui.menu.ToolsMenu;
import com.limegroup.gnutella.gui.menu.ViewMenu;
import javax.swing.JMenuBar;

public final class MenuMediator {
    private static final MenuMediator INSTANCE = new MenuMediator();
    private final JMenuBar MENU_BAR = new JMenuBar();
    private final FileMenu FILE_MENU = new FileMenu("FILE");
    private final NavMenu NAV_MENU = new NavMenu("NAV");
    private final Menu RESOURCES_MENU = new ResourcesMenu("RESOURCES");
    private final Menu TOOLS_MENU = new ToolsMenu("TOOLS");
    private final Menu HELP_MENU = new HelpMenu("HELP");
    private final Menu VIEW_MENU = new ViewMenu("VIEW");

    public static final MenuMediator instance() {
        return INSTANCE;
    }

    private MenuMediator() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_MENUS"));
        this.MENU_BAR.setFont(AbstractMenu.FONT);
        this.addMenu(this.FILE_MENU);
        this.addMenu(this.VIEW_MENU);
        this.addMenu(this.NAV_MENU);
        this.addMenu(this.RESOURCES_MENU);
        this.addMenu(this.TOOLS_MENU);
        this.addMenu(this.HELP_MENU);
    }

    public JMenuBar getMenuBar() {
        return this.MENU_BAR;
    }

    public void handleLibrarySelection() {
        this.FILE_MENU.handleLibrarySelection();
    }

    public void handleStandardSelection() {
        this.FILE_MENU.handleStandardSelection();
    }

    public void setConnected(boolean connected) {
        this.FILE_MENU.setConnected(connected);
    }

    private void addMenu(Menu menu) {
        this.MENU_BAR.add(menu.getMenu());
    }

    public void setNavMenuItemEnabled(int TAB_INDEX, boolean ENABLED) {
        this.NAV_MENU.setNavMenuItemEnabled(TAB_INDEX, ENABLED);
    }

    public int getMenuBarHeight() {
        return this.MENU_BAR.getHeight();
    }
}

