/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import javax.swing.SwingUtilities;

final class WindowsNotifyUser
implements NotifyUser {
    private int _handler = 0;
    private String _tooltip;
    private String _imageFileName;

    WindowsNotifyUser() {
    }

    public void addNotify() {
        String tip = GUIMediator.getStringResource("TRAY_TOOLTIP");
        this.updateNotify("LimeWire.ico", tip);
    }

    public void removeNotify() {
        this.nativeDisable();
    }

    public void updateNotify(String imageFile, String tooltip) {
        this._tooltip = tooltip;
        this._imageFileName = imageFile;
        int imageInt = WindowsNotifyUser.nativeLoadImage(imageFile);
        if (imageInt == -1) {
            return;
        }
        this.nativeEnable(imageInt, this._tooltip);
    }

    public void updateImage(String imageFileName) {
        this.updateNotify(imageFileName, this._tooltip);
    }

    public void updateDesc(String desc) {
        this.updateNotify(this._imageFileName, desc);
    }

    public void hideNotify() {
        this.nativeHide();
    }

    public void restoreApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.restoreView();
            }
        });
    }

    public void exitApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.shutdown();
            }
        });
    }

    public void exitAfterTransfers() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.shutdownAfterTransfers();
            }
        });
    }

    public void showAboutWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.showAboutWindow();
            }
        });
    }

    private synchronized native void nativeDisable() throws UnsatisfiedLinkError;

    private synchronized native void nativeEnable(int var1, String var2) throws UnsatisfiedLinkError;

    private static synchronized native void nativeFreeImage(int var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImage(String var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImageFromResource(int var0) throws UnsatisfiedLinkError;

    private synchronized native void nativeHide() throws UnsatisfiedLinkError;
}

