/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedPasswordField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.DaapSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public final class DaapPasswordPaneItem
extends AbstractPaneItem {
    private final String CHECK_BOX_LABEL = "OPTIONS_ITUNES_DAAP_PASSWORD_CHECKBOX_LABEL";
    private final String TEXTFIELD_BOX_LABEL = "OPTIONS_ITUNES_DAAP_PASSWORD_TEXTFIELD_LABEL";
    private final JCheckBox CHECK_BOX = new JCheckBox();
    private final JTextField TEXT_FIELD = new SizedPasswordField();

    public DaapPasswordPaneItem(String key) {
        super(key);
        LabeledComponent comp = new LabeledComponent("OPTIONS_ITUNES_DAAP_PASSWORD_CHECKBOX_LABEL", this.CHECK_BOX, 120);
        this.add(comp.getComponent());
        comp = new LabeledComponent("OPTIONS_ITUNES_DAAP_PASSWORD_TEXTFIELD_LABEL", this.TEXT_FIELD, 130);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(DaapSettings.DAAP_REQUIRES_PASSWORD.getValue());
        if (DaapSettings.DAAP_REQUIRES_PASSWORD.getValue()) {
            this.TEXT_FIELD.setText(DaapSettings.DAAP_PASSWORD.getValue());
        }
    }

    public boolean applyOptions() throws IOException {
        boolean prevRequiresPassword = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
        String prevPassword = DaapSettings.DAAP_PASSWORD.getValue();
        boolean requiresPassword = this.CHECK_BOX.isSelected();
        String password = this.TEXT_FIELD.getText().trim();
        if (password.equals("") && requiresPassword) {
            throw new IOException();
        }
        if (!password.equals(prevPassword)) {
            DaapSettings.DAAP_PASSWORD.setValue(password);
        }
        if (requiresPassword != prevRequiresPassword || requiresPassword && !password.equals(prevPassword)) {
            DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(requiresPassword);
            try {
                if (requiresPassword) {
                    DaapManager.instance().disconnectAll();
                }
                DaapManager.instance().updateService();
            }
            catch (IOException err) {
                DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(prevRequiresPassword);
                DaapSettings.DAAP_PASSWORD.setValue(prevPassword);
                DaapManager.instance().stop();
                this.initOptions();
                throw err;
            }
        }
        return false;
    }

    public boolean isDirty() {
        return DaapSettings.DAAP_REQUIRES_PASSWORD.getValue() != this.CHECK_BOX.isSelected() || !DaapSettings.DAAP_PASSWORD.getValue().equals(this.TEXT_FIELD.getText().trim());
    }
}

