/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.NetworkUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class ForceIPPaneItem
extends AbstractPaneItem {
    private final WholeNumberField PORT_FIELD = new SizedWholeNumberField();
    private final ButtonGroup BUTTONS = new ButtonGroup();
    private final JRadioButton UPNP = new JRadioButton(GUIMediator.getStringResource("OPTIONS_ROUTER_UPNP"));
    private final JRadioButton PORT = new JRadioButton(GUIMediator.getStringResource("OPTIONS_ROUTER_PORT"));
    private final JRadioButton NONE = new JRadioButton(GUIMediator.getStringResource("OPTIONS_ROUTER_NOTHING"));

    public ForceIPPaneItem(String key) {
        super(key);
        this.BUTTONS.add(this.UPNP);
        this.BUTTONS.add(this.PORT);
        this.BUTTONS.add(this.NONE);
        this.PORT.addItemListener(new LocalPortListener());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 6);
        panel.add((Component)this.UPNP, c);
        c.gridwidth = -1;
        panel.add((Component)this.PORT, c);
        c.gridwidth = 0;
        panel.add((Component)this.PORT_FIELD, c);
        panel.add((Component)this.NONE, c);
        this.add(GUIUtils.left(panel));
    }

    private void updateState() {
        this.PORT_FIELD.setEnabled(this.PORT.isSelected());
        this.PORT_FIELD.setEditable(this.PORT.isSelected());
    }

    public void initOptions() {
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue()) {
            this.PORT.setSelected(true);
        } else if (ConnectionSettings.DISABLE_UPNP.getValue()) {
            this.NONE.setSelected(true);
        } else {
            this.UPNP.setSelected(true);
        }
        this.PORT_FIELD.setValue(ConnectionSettings.FORCED_PORT.getValue());
        this.updateState();
    }

    public boolean applyOptions() throws IOException {
        boolean restart = false;
        boolean oldUPNP = ConnectionSettings.UPNP_IN_USE.getValue();
        int oldPort = ConnectionSettings.FORCED_PORT.getValue();
        boolean oldForce = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
        if (this.UPNP.isSelected()) {
            if (!ConnectionSettings.UPNP_IN_USE.getValue()) {
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
            }
            ConnectionSettings.DISABLE_UPNP.setValue(false);
            if (!oldUPNP) {
                restart = true;
            }
        } else if (this.NONE.isSelected()) {
            ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
            ConnectionSettings.DISABLE_UPNP.setValue(true);
        } else {
            int forcedPort = this.PORT_FIELD.getValue();
            if (!NetworkUtils.isValidPort(forcedPort)) {
                GUIMediator.showError("ERROR_FORCE_IP_PORT_RANGE");
                throw new IOException("bad port: " + forcedPort);
            }
            ConnectionSettings.DISABLE_UPNP.setValue(false);
            ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
            ConnectionSettings.UPNP_IN_USE.setValue(false);
            ConnectionSettings.FORCED_PORT.setValue(forcedPort);
        }
        boolean newForce = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
        int newPort = ConnectionSettings.FORCED_PORT.getValue();
        if (oldForce != newForce || newForce && oldPort != newPort) {
            RouterService.addressChanged();
        }
        return false;
    }

    public boolean isDirty() {
        boolean disabled = ConnectionSettings.DISABLE_UPNP.getValue();
        boolean upnp = ConnectionSettings.UPNP_IN_USE.getValue() || !ConnectionSettings.FORCE_IP_ADDRESS.getValue();
        boolean forced = ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue();
        int port = ConnectionSettings.FORCED_PORT.getValue();
        return this.NONE.isSelected() != disabled || this.UPNP.isSelected() != upnp || this.PORT.isSelected() != forced || this.PORT.isSelected() && this.PORT_FIELD.getValue() != port;
    }

    private class LocalPortListener
    implements ItemListener {
        private LocalPortListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ForceIPPaneItem.this.updateState();
        }
    }
}

