/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class ShutdownPaneItem
extends AbstractPaneItem {
    private JRadioButton shutdownImmediately;
    private JRadioButton shutdownAfterTransfers;
    private JRadioButton minimizeToTray;

    public ShutdownPaneItem(String key) {
        super(key);
        BoxPanel buttonPanel = new BoxPanel();
        String immediateLabel = "OPTIONS_SHUTDOWN_IMMEDIATELY_LABEL";
        String whenReadyLabel = "OPTIONS_SHUTDOWN_AFTER_TRANSFERS_LABEL";
        String minimizeLabel = "OPTIONS_SHUTDOWN_TO_TRAY_LABEL";
        this.shutdownImmediately = new JRadioButton(MEDIATOR.getString(immediateLabel));
        this.shutdownAfterTransfers = new JRadioButton(MEDIATOR.getString(whenReadyLabel));
        this.minimizeToTray = new JRadioButton(MEDIATOR.getString(minimizeLabel));
        ButtonGroup bg = new ButtonGroup();
        buttonPanel.add(this.shutdownImmediately);
        buttonPanel.add(this.shutdownAfterTransfers);
        bg.add(this.shutdownImmediately);
        bg.add(this.shutdownAfterTransfers);
        if (CommonUtils.supportsTray()) {
            buttonPanel.add(this.minimizeToTray);
            bg.add(this.minimizeToTray);
        }
        BoxPanel mainPanel = new BoxPanel(0);
        mainPanel.add(Box.createHorizontalGlue());
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createHorizontalGlue());
        this.add(mainPanel);
    }

    public boolean applyOptions() throws IOException {
        if (this.minimizeToTray.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(true);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(false);
        } else if (this.shutdownAfterTransfers.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(true);
        } else {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(false);
        }
        return false;
    }

    public void initOptions() {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            this.minimizeToTray.setSelected(true);
        } else if (ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue()) {
            this.shutdownAfterTransfers.setSelected(true);
        } else {
            this.shutdownImmediately.setSelected(true);
        }
    }

    public boolean isDirty() {
        boolean minimized = ApplicationSettings.MINIMIZE_TO_TRAY.getValue() && !ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue();
        boolean afterTransfers = !ApplicationSettings.MINIMIZE_TO_TRAY.getValue() && ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue();
        return this.minimizeToTray.isSelected() != minimized || this.shutdownAfterTransfers.isSelected() != afterTransfers;
    }
}

