/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.playlist;

import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.mp3.PlayList;
import com.limegroup.gnutella.gui.playlist.PlaylistButtons;
import com.limegroup.gnutella.gui.playlist.PlaylistModel;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DragManager;
import com.limegroup.gnutella.gui.tables.FileTransfer;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

public final class PlaylistMediator
extends AbstractTableMediator {
    private static final PlaylistMediator INSTANCE = new PlaylistMediator();
    private final Object PLAY_LOCK = new Object();
    private PlayList _playList;
    private PlayList _tempPL = new PlayList(".temp.m3u.LW");
    private boolean _continuous = true;
    private boolean _songPlaying = false;
    private File _oneTimeSongToPlay = null;
    private File _lastOpenedPlaylist;
    private File _lastSavedPlaylist;
    ActionListener LOAD_LISTENER;
    ActionListener SAVE_LISTENER;
    ActionListener CONTINUOUS_LISTENER;
    ActionListener SHUFFLE_LISTENER;
    private PlaylistModel MODEL;

    public static PlaylistMediator instance() {
        return INSTANCE;
    }

    protected void buildListeners() {
        super.buildListeners();
        this.LOAD_LISTENER = new LoadListener();
        this.SAVE_LISTENER = new SaveListener();
        this.CONTINUOUS_LISTENER = new ContinuousListener();
        this.SHUFFLE_LISTENER = new ShuffleListener();
    }

    protected void addListeners() {
        super.addListeners();
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("PLAYLIST_TITLE"));
        this.MODEL = new PlaylistModel();
        this.DATA_MODEL = this.MODEL;
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new PlaylistButtons(this).getComponent();
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_PLAYLIST_WINDOW"));
    }

    private PlaylistMediator() {
        super("PLAYLIST_TABLE");
        ThemeMediator.addThemeObserver(this);
    }

    protected JPopupMenu createPopupMenu() {
        return null;
    }

    protected void setupMainPanel() {
        this.MAIN_PANEL.add(this.getScrolledTablePane());
        this.MAIN_PANEL.add(Box.createVerticalStrut(6));
        JPanel options = this.buildOptionsPanel();
        this.MAIN_PANEL.add(options);
        this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
    }

    protected void setupDragAndDrop() {
        DragManager.install(this.TABLE);
    }

    public void handleSelection(int row) {
        this.setButtonEnabled(2, true);
    }

    public void handleNoSelection() {
        this.setButtonEnabled(2, false);
    }

    public void handleActionKey() {
        this.playSong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileToPlay() {
        File retFile = null;
        Object object = this.PLAY_LOCK;
        synchronized (object) {
            if (this._oneTimeSongToPlay != null) {
                retFile = this._oneTimeSongToPlay;
                this._oneTimeSongToPlay = null;
                return retFile;
            }
            if (!this.isContinuous()) {
                return null;
            }
            retFile = this.MODEL.getNextSong();
            this._songPlaying = true;
        }
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.refresh();
                    int playIndex = PlaylistMediator.this.MODEL.getCurrentSongIndex();
                    if (playIndex >= 0) {
                        PlaylistMediator.this.TABLE.ensureRowVisible(playIndex);
                    }
                }
            }
        });
        return retFile;
    }

    public void addFileToPlaylist(final File f) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.add(f);
                    PlayList pl = PlaylistMediator.this.getCurrentPlayList();
                    if (pl != null) {
                        pl.setSongs(PlaylistMediator.this.MODEL.getSongs());
                    }
                }
            }
        });
    }

    public void addFilesToPlaylist(final File[] fs) {
        if (fs == null || fs.length == 0) {
            return;
        }
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    for (int i = 0; i < fs.length; ++i) {
                        PlaylistMediator.this.addFileToPlaylist(fs[i]);
                    }
                }
            }
        });
    }

    public boolean isSongSelected() {
        return this.TABLE.getSelectedRow() != -1;
    }

    public void setBackwardsMode() {
        this.MODEL.setBackwardsMode();
    }

    public boolean isSongPlaying() {
        return this._songPlaying;
    }

    public void playSongNext(File f) {
        this._oneTimeSongToPlay = f;
    }

    public boolean isContinuous() {
        return this._continuous;
    }

    public void playStarted() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                PlaylistMediator.this.refresh();
            }
        });
    }

    public void playComplete(boolean hardStop) {
        if (!hardStop) {
            return;
        }
        this._songPlaying = false;
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                PlaylistMediator.this.refresh();
            }
        });
    }

    private JPanel buildOptionsPanel() {
        JLabel options = new JLabel(GUIMediator.getStringResource("PLAYLIST_OPTIONS_STRING"));
        JCheckBox shuffle = new JCheckBox(GUIMediator.getStringResource("PLAYLIST_OPTIONS_SHUFFLE"), false);
        shuffle.addActionListener(this.SHUFFLE_LISTENER);
        JCheckBox continuous = new JCheckBox(GUIMediator.getStringResource("PLAYLIST_OPTIONS_CONTINUE"), true);
        continuous.addActionListener(this.CONTINUOUS_LISTENER);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.add(options);
        checkBoxPanel.add(continuous);
        checkBoxPanel.add(shuffle);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)this.BUTTON_ROW, "West");
        optionsPanel.add((Component)checkBoxPanel, "East");
        return optionsPanel;
    }

    private void playSong() {
        DataLine line = this.TABLE.getSelectedDataLine();
        if (line == null) {
            return;
        }
        File f = ((FileTransfer)((Object)line)).getFile();
        this.MODEL.setCurrentSong(f);
        MediaPlayerComponent.playSongImmediately(f);
        this._songPlaying = true;
    }

    private PlayList getCurrentPlayList() {
        return this._playList != null ? this._playList : this._tempPL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlaylist() {
        File selFile;
        String parent;
        File parentFile = null;
        if (this._lastOpenedPlaylist != null && (parent = this._lastOpenedPlaylist.getParent()) != null) {
            parentFile = new File(parent);
        }
        if (parentFile == null) {
            parentFile = CommonUtils.getCurrentDirectory();
        }
        if ((selFile = FileChooserHandler.getInputFile((Component)this.getComponent(), "PLAYLIST_DIALOG_OPEN_TITLE", parentFile, new PlayListFileFilter())) == null || !selFile.isFile()) {
            return;
        }
        String path = selFile.getPath();
        try {
            path = selFile.getCanonicalPath();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        PlayList pl = new PlayList(path);
        Object object = this.PLAY_LOCK;
        synchronized (object) {
            this._lastOpenedPlaylist = selFile;
            this._playList = pl;
            this.clearTable();
            this.MODEL.addSongs(this._playList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePlaylist() {
        File selFile;
        String parent;
        File parentFile = null;
        if (this._lastSavedPlaylist != null && (parent = this._lastSavedPlaylist.getParent()) != null) {
            parentFile = new File(parent);
        }
        if (parentFile == null) {
            parentFile = CommonUtils.getCurrentDirectory();
        }
        if ((selFile = FileChooserHandler.getInputFile(this.getComponent(), "PLAYLIST_DIALOG_SAVE_TITLE", "PLAYLIST_DIALOG_SAVE_SAVE", parentFile, new PlayListFileFilter())) == null) {
            return;
        }
        String path = selFile.getPath();
        try {
            path = selFile.getCanonicalPath();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (!path.toLowerCase().endsWith(".m3u")) {
            path = path + ".m3u";
        }
        PlayList pl = new PlayList(path);
        Object object = this.PLAY_LOCK;
        synchronized (object) {
            this._lastSavedPlaylist = new File(path);
            this._playList = pl;
            this._playList.setSongs(this.MODEL.getSongs());
            this._tempPL = null;
        }
        try {
            this._playList.save();
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    private static class PlayListFileFilter
    extends FileFilter {
        private PlayListFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("m3u");
        }

        public String getDescription() {
            return GUIMediator.getStringResource("PLAYLIST_FILE_DESCRIPTION");
        }
    }

    private class ShuffleListener
    implements ActionListener {
        private ShuffleListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            PlaylistMediator.this.MODEL.setShuffle(b.isSelected());
        }
    }

    private class ContinuousListener
    implements ActionListener {
        private ContinuousListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            PlaylistMediator.this._continuous = b.isSelected();
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PlaylistMediator.this.savePlaylist();
        }
    }

    private class LoadListener
    implements ActionListener {
        private LoadListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PlaylistMediator.this.loadPlaylist();
        }
    }
}

