/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.playlist;

import com.limegroup.gnutella.gui.mp3.PlayList;
import com.limegroup.gnutella.gui.playlist.PlaylistDataLine;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.DataLine;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class PlaylistModel
extends BasicDataLineModel {
    private boolean _shuffle = false;
    private boolean _nextIsBefore = false;
    private File _currentSong;
    private List _songsNotPlayed;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$playlist$PlaylistDataLine;

    PlaylistModel() {
        super(class$com$limegroup$gnutella$gui$playlist$PlaylistDataLine == null ? (class$com$limegroup$gnutella$gui$playlist$PlaylistDataLine = PlaylistModel.class$("com.limegroup.gnutella.gui.playlist.PlaylistDataLine")) : class$com$limegroup$gnutella$gui$playlist$PlaylistDataLine);
    }

    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    public DataLine createDataLine() {
        return new PlaylistDataLine();
    }

    public int add(Object o) {
        return this.add(o, this.getRowCount());
    }

    public int add(DataLine dl, int row) {
        if (this._shuffle) {
            this._songsNotPlayed.add(dl.getInitializeObject());
            Collections.shuffle(this._songsNotPlayed);
        }
        return super.add(dl, row);
    }

    public void remove(int i) {
        File f = (File)this.get(i).getInitializeObject();
        super.remove(i);
        if (this._shuffle) {
            this._songsNotPlayed.remove(f);
        }
    }

    public void clear() {
        super.clear();
        if (this._shuffle) {
            this._songsNotPlayed.clear();
        }
    }

    File getNextSong() {
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return null;
        }
        boolean prior = this._nextIsBefore;
        this._nextIsBefore = false;
        if (this._shuffle) {
            if (this._songsNotPlayed.isEmpty()) {
                for (int i = 0; i < rowCount; ++i) {
                    this._songsNotPlayed.add(this.get(i).getInitializeObject());
                }
                Collections.shuffle(this._songsNotPlayed);
            }
            this._currentSong = (File)this._songsNotPlayed.remove(0);
        } else {
            int idx = this.getRow(this._currentSong);
            idx = idx == -1 ? 0 : (prior ? (idx - 1 + rowCount) % rowCount : (idx + 1 + rowCount) % rowCount);
            this._currentSong = (File)this.get(idx).getInitializeObject();
        }
        return this._currentSong;
    }

    void setCurrentSong(File f) {
        if (this._shuffle) {
            this._songsNotPlayed.remove(f);
        }
        this._currentSong = f;
    }

    int getCurrentSongIndex() {
        return this.getRow(this._currentSong);
    }

    List getSongs() {
        LinkedList<Object> l = new LinkedList<Object>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            DataLine dl = this.get(i);
            l.add(dl.getInitializeObject());
        }
        return l;
    }

    void setBackwardsMode() {
        this._nextIsBefore = true;
    }

    void addSongs(PlayList list) {
        this.unsort();
        List songs = list.getSongs();
        Iterator i = songs.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    void setShuffle(boolean shuffle) {
        this._songsNotPlayed = shuffle ? new LinkedList() : null;
        this._shuffle = shuffle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

