/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;

final class CancelSearchIconProxy
implements Icon {
    private static final int PLAIN = 0;
    private static final int SELECTED = 1;
    private static final int ARMED = 2;
    private static Icon PLAIN_ICON;
    private static Icon SELECTED_ICON;
    private static Icon ARMED_ICON;
    private Icon _cancelIcon;
    private int _width;
    private int _height;
    private int _x;
    private int _y;
    private final int style;

    static CancelSearchIconProxy createPlain() {
        return new CancelSearchIconProxy(0);
    }

    static CancelSearchIconProxy createSelected() {
        return new CancelSearchIconProxy(1);
    }

    static CancelSearchIconProxy createArmed() {
        return new CancelSearchIconProxy(2);
    }

    CancelSearchIconProxy(int style) {
        this.style = style;
        this.setIcon();
    }

    private void setIcon() {
        switch (this.style) {
            case 2: {
                this._cancelIcon = ARMED_ICON;
                break;
            }
            case 1: {
                this._cancelIcon = SELECTED_ICON;
                break;
            }
            case 0: {
                this._cancelIcon = PLAIN_ICON;
            }
        }
        this._width = this._cancelIcon.getIconWidth();
        this._height = this._cancelIcon.getIconHeight();
        this._x = 0;
        this._y = 0;
    }

    static void updateTheme() {
        if (ThemeSettings.isWindowsTheme() && WindowsXPIcon.isAvailable()) {
            try {
                PLAIN_ICON = new WindowsXPIcon(0);
                SELECTED_ICON = new WindowsXPIcon(1);
                ARMED_ICON = new WindowsXPIcon(2);
                return;
            }
            catch (IllegalArgumentException iae) {
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        PLAIN_ICON = GUIMediator.getThemeImage("kill");
        try {
            SELECTED_ICON = GUIMediator.getThemeImage("kill_on");
        }
        catch (MissingResourceException mre) {
            SELECTED_ICON = PLAIN_ICON;
        }
        ARMED_ICON = SELECTED_ICON;
    }

    public int getIconWidth() {
        return this._width;
    }

    public int getIconHeight() {
        return this._height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this._x = x;
        this._y = y;
        this._cancelIcon.paintIcon(c, g, x, y);
    }

    boolean shouldKill(int x, int y) {
        int xMax = this._x + this._width;
        int yMax = this._y + this._height;
        if (x < this._x || x > xMax) {
            return false;
        }
        return y >= this._y && y <= yMax;
    }

    private static class WindowsXPIcon
    implements Icon {
        private static Icon _windowsCloseIcon;
        private static final Icon NULL;
        private Component component;
        private Icon _resizedIcon;

        static boolean isAvailable() {
            if (!(CommonUtils.isJava142OrLater() && CommonUtils.isWindowsXP() && Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) && System.getProperty("swing.noxp") == null)) {
                return false;
            }
            if (_windowsCloseIcon == NULL) {
                return false;
            }
            if (_windowsCloseIcon != null) {
                return true;
            }
            try {
                Class<?> c = Class.forName("com.sun.java.swing.plaf.windows.WindowsIconFactory");
                Method m = c.getDeclaredMethod("createFrameCloseIcon", new Class[0]);
                _windowsCloseIcon = (Icon)m.invoke(c, new Object[0]);
                if (_windowsCloseIcon.getIconHeight() == 0 || _windowsCloseIcon.getIconWidth() == 0) {
                    _windowsCloseIcon = NULL;
                    return false;
                }
                return true;
            }
            catch (ClassNotFoundException cfnfe) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (ExceptionInInitializerError eiie) {
            }
            catch (SecurityException se) {
            }
            catch (ClassCastException cce) {
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            _windowsCloseIcon = NULL;
            return false;
        }

        WindowsXPIcon(int style) {
            Icon icon;
            JButton button = new JButton();
            button.getModel().setArmed(false);
            button.getModel().setPressed(false);
            button.getModel().setRollover(style == 2);
            button.getModel().setEnabled(true);
            JInternalFrame frame = new JInternalFrame(this, style){
                private final /* synthetic */ int val$style;
                private final /* synthetic */ WindowsXPIcon this$0;
                {
                    this.this$0 = this$0;
                    this.val$style = val$style;
                }

                public boolean isSelected() {
                    return this.val$style != 0;
                }
            };
            frame.getContentPane().add(button);
            this.component = button;
            this._resizedIcon = icon = ImageManipulator.resize(this, 14, 14);
            this.component = null;
        }

        public int getIconHeight() {
            if (this._resizedIcon != null) {
                return this._resizedIcon.getIconHeight();
            }
            return _windowsCloseIcon.getIconHeight();
        }

        public int getIconWidth() {
            if (this._resizedIcon != null) {
                return this._resizedIcon.getIconWidth();
            }
            return _windowsCloseIcon.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this._resizedIcon != null) {
                this._resizedIcon.paintIcon(c, g, x, y);
            } else {
                g.translate(x, y);
                _windowsCloseIcon.paintIcon(this.component, g, 0, 0);
                g.translate(-x, -y);
            }
        }

        static {
            NULL = new ImageIcon();
        }
    }
}

